/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gametest;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraftforge.event.RegisterGameTestsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.gametest.GameTestDontPrefix;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.GameTestPrefix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@ApiStatus.Internal
public class ForgeGameTestHooks {
    private static boolean registeredGametests = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type GAME_TEST_HOLDER = Type.getType(GameTestHolder.class);
    private static final String DEFAULT_BATCH = ForgeGameTestHooks.getDefaultBatch();

    public static boolean isGametestEnabled() {
        return !FMLLoader.isProduction() && (SharedConstants.IS_RUNNING_IN_IDE || ForgeGameTestHooks.isGametestServer() || Boolean.getBoolean("forge.enableGameTest"));
    }

    public static boolean isGametestServer() {
        return !FMLLoader.isProduction() && Boolean.getBoolean("forge.gameTestServer");
    }

    public static void registerGametests() {
        if (!registeredGametests && ForgeGameTestHooks.isGametestEnabled() && ModLoader.isLoadingStateValid()) {
            Set<String> enabledNamespaces = ForgeGameTestHooks.getEnabledNamespaces();
            LOGGER.info("Enabled Gametest Namespaces: {}", enabledNamespaces);
            HashSet<Method> gameTestMethods = new HashSet<Method>();
            RegisterGameTestsEvent event = new RegisterGameTestsEvent(gameTestMethods);
            ModLoader.get().postEvent((Event)event);
            ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> GAME_TEST_HOLDER.equals((Object)a.annotationType())).forEach(a -> ForgeGameTestHooks.addGameTestMethods(a, gameTestMethods));
            for (Method gameTestMethod : gameTestMethods) {
                GameTestRegistry.register((Method)gameTestMethod, enabledNamespaces);
            }
            registeredGametests = true;
        }
    }

    private static Set<String> getEnabledNamespaces() {
        String enabledNamespacesStr = System.getProperty("forge.enabledGameTestNamespaces");
        if (enabledNamespacesStr == null) {
            return Set.of();
        }
        return Arrays.stream(enabledNamespacesStr.split(",")).filter(s -> !s.isBlank()).collect(Collectors.toUnmodifiableSet());
    }

    private static void addGameTestMethods(ModFileScanData.AnnotationData annotationData, Set<Method> gameTestMethods) {
        try {
            Class<?> clazz = Class.forName(annotationData.clazz().getClassName(), true, ForgeGameTestHooks.class.getClassLoader());
            gameTestMethods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTestName(Method method, GameTest meta) {
        String name = method.getName().toLowerCase(Locale.ENGLISH);
        return ForgeGameTestHooks.getPrefixed(method, name);
    }

    private static String getPrefixed(Method method, String name) {
        String prefix = ForgeGameTestHooks.getPrefix(method);
        return prefix == null ? name : prefix + "." + name;
    }

    @Nullable
    private static String getPrefix(Method method) {
        boolean shouldPrefix;
        Class<?> cls = method.getDeclaringClass();
        boolean bl = shouldPrefix = !method.isAnnotationPresent(GameTestDontPrefix.class) && !cls.isAnnotationPresent(GameTestDontPrefix.class);
        if (!shouldPrefix) {
            return null;
        }
        GameTestPrefix prefix = cls.getAnnotation(GameTestPrefix.class);
        if (prefix != null) {
            return prefix.value();
        }
        GameTestHolder holder = cls.getAnnotation(GameTestHolder.class);
        if (holder != null && !holder.value().isEmpty()) {
            return holder.value();
        }
        Mod mod = method.getDeclaringClass().getAnnotation(Mod.class);
        if (mod != null) {
            return mod.value();
        }
        return cls.getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    public static String getTestTemplate(Method method, GameTest meta, String testName) {
        if (meta.template().indexOf(58) != -1) {
            return meta.template();
        }
        String template = null;
        template = meta.template().isEmpty() ? testName : ForgeGameTestHooks.getPrefixed(method, meta.template());
        Class<?> cls = method.getDeclaringClass();
        GameTestHolder holder = cls.getAnnotation(GameTestHolder.class);
        if (holder != null && !holder.namespace().isEmpty()) {
            return holder.namespace() + ":" + template;
        }
        Mod mod = cls.getAnnotation(Mod.class);
        if (mod != null) {
            return mod.value() + ":" + template;
        }
        return template;
    }

    private static String getDefaultBatch() {
        try {
            return (String)ObfuscationReflectionHelper.findMethod(GameTest.class, (String)"m_177043_", (Class[])new Class[0]).getDefaultValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "defaultBatch";
        }
    }

    public static String getTestBatch(Method method, GameTest gametest) {
        String batch = gametest.batch();
        if (DEFAULT_BATCH.equals(batch)) {
            String prefix = ForgeGameTestHooks.getPrefix(method);
            return prefix == null ? batch : prefix;
        }
        return ForgeGameTestHooks.getPrefixed(method, batch.toLowerCase(Locale.ENGLISH));
    }

    public static void addTest(Collection<TestFunction> functions, Set<String> classes, Set<String> filters, TestFunction func) {
        boolean allowed;
        boolean bl = allowed = filters.isEmpty() || filters.stream().anyMatch(f -> f.equals(func.batchName()) || func.batchName().startsWith(f + "."));
        if (!allowed) {
            return;
        }
        functions.add(func);
        String batch = func.batchName();
        classes.add(batch);
        int idx = batch.indexOf(46);
        while (idx != -1) {
            batch = batch.substring(0, idx);
            idx = batch.indexOf(46);
            classes.add(batch);
        }
    }
}

