/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.filters;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.RootCommandNode;
import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.TestClassNameArgument;
import net.minecraft.gametest.framework.TestFunctionArgument;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.network.ConnectionType;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.filters.CommandTreeCleaner;
import net.minecraftforge.network.filters.VanillaPacketFilter;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
public class VanillaConnectionNetworkFilter
extends VanillaPacketFilter {
    public VanillaConnectionNetworkFilter() {
        super((Map<Class<? extends Packet<?>>, BiConsumer<Packet<?>, List<? super Packet<?>>>>)ImmutableMap.builder().put(VanillaConnectionNetworkFilter.handler(ClientboundUpdateAttributesPacket.class, VanillaConnectionNetworkFilter::filterEntityProperties)).put(VanillaConnectionNetworkFilter.handler(ClientboundCommandsPacket.class, VanillaConnectionNetworkFilter::filterCommandList)).build());
    }

    @Override
    protected boolean isNecessary(Connection connection) {
        return NetworkContext.get(connection).getType() == ConnectionType.VANILLA;
    }

    @NotNull
    private static ClientboundUpdateAttributesPacket filterEntityProperties(ClientboundUpdateAttributesPacket msg) {
        ClientboundUpdateAttributesPacket newPacket = new ClientboundUpdateAttributesPacket(msg.getEntityId(), Collections.emptyList());
        msg.getValues().stream().filter(snapshot -> {
            ResourceLocation key = ForgeRegistries.ATTRIBUTES.getKey((Attribute)snapshot.attribute().get());
            return key != null && key.getNamespace().equals("minecraft");
        }).forEach(snapshot -> newPacket.getValues().add(snapshot));
        return newPacket;
    }

    @NotNull
    private static ClientboundCommandsPacket filterCommandList(ClientboundCommandsPacket packet) {
        CommandBuildContext commandBuildContext = Commands.createValidationContext((HolderLookup.Provider)VanillaRegistries.createLookup());
        RootCommandNode root = packet.getRoot(commandBuildContext);
        RootCommandNode newRoot = CommandTreeCleaner.cleanArgumentTypes(root, argType -> {
            if (argType instanceof TestFunctionArgument || argType instanceof TestClassNameArgument) {
                return false;
            }
            ArgumentTypeInfo info = ArgumentTypeInfos.byClass((ArgumentType)argType);
            ResourceLocation id = BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getKey((Object)info);
            return id != null && (id.getNamespace().equals("minecraft") || id.getNamespace().equals("brigadier"));
        });
        return new ClientboundCommandsPacket(newRoot);
    }
}

