/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.blaze3d.platform.Window;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;

public sealed interface CustomizeGuiOverlayEvent {
    public Window getWindow();

    public GuiGraphics getGuiGraphics();

    public float getPartialTick();

    public static final class Chat
    extends MutableEvent
    implements CustomizeGuiOverlayEvent {
        public static final EventBus<Chat> BUS = EventBus.create(Chat.class);
        private final Window window;
        private final GuiGraphics guiGraphics;
        private final float partialTick;
        private int posX;
        private int posY;

        @ApiStatus.Internal
        public Chat(Window window, GuiGraphics guiGraphics, float partialTick, int posX, int posY) {
            this.window = window;
            this.guiGraphics = guiGraphics;
            this.partialTick = partialTick;
            this.setPosX(posX);
            this.setPosY(posY);
        }

        @Override
        public Window getWindow() {
            return this.window;
        }

        @Override
        public GuiGraphics getGuiGraphics() {
            return this.guiGraphics;
        }

        @Override
        public float getPartialTick() {
            return this.partialTick;
        }

        public int getPosX() {
            return this.posX;
        }

        public void setPosX(int posX) {
            this.posX = posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public void setPosY(int posY) {
            this.posY = posY;
        }
    }

    public record DebugText(Window getWindow, GuiGraphics getGuiGraphics, float getPartialTick, List<String> getText, Side getSide) implements RecordEvent,
    CustomizeGuiOverlayEvent
    {
        public static final EventBus<DebugText> BUS = EventBus.create(DebugText.class);

        public static enum Side {
            Left,
            Right;

        }
    }

    public static final class BossEventProgress
    extends MutableEvent
    implements Cancellable,
    CustomizeGuiOverlayEvent {
        public static final CancellableEventBus<BossEventProgress> BUS = CancellableEventBus.create(BossEventProgress.class);
        private final Window window;
        private final GuiGraphics guiGraphics;
        private final float partialTick;
        private final LerpingBossEvent bossEvent;
        private final int x;
        private final int y;
        private int increment;

        @ApiStatus.Internal
        public BossEventProgress(Window window, GuiGraphics guiGraphics, float partialTick, LerpingBossEvent bossEvent, int x, int y, int increment) {
            this.window = window;
            this.guiGraphics = guiGraphics;
            this.partialTick = partialTick;
            this.bossEvent = bossEvent;
            this.x = x;
            this.y = y;
            this.increment = increment;
        }

        @Override
        public Window getWindow() {
            return this.window;
        }

        @Override
        public GuiGraphics getGuiGraphics() {
            return this.guiGraphics;
        }

        @Override
        public float getPartialTick() {
            return this.partialTick;
        }

        public LerpingBossEvent getBossEvent() {
            return this.bossEvent;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getIncrement() {
            return this.increment;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }
    }
}

