/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;

@FunctionalInterface
public interface IQuadTransformer {
    public static final int STRIDE = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
    public static final int POSITION = IQuadTransformer.findOffset(VertexFormatElement.POSITION);
    public static final int COLOR = IQuadTransformer.findOffset(VertexFormatElement.COLOR);
    public static final int UV0 = IQuadTransformer.findOffset(VertexFormatElement.UV0);
    public static final int UV1 = IQuadTransformer.findOffset(VertexFormatElement.UV1);
    public static final int UV2 = IQuadTransformer.findOffset(VertexFormatElement.UV2);
    public static final int NORMAL = IQuadTransformer.findOffset(VertexFormatElement.NORMAL);

    public BakedQuad process(BakedQuad var1);

    default public List<BakedQuad> process(List<BakedQuad> inputs) {
        return inputs.stream().map(this::process).toList();
    }

    default public IQuadTransformer andThen(IQuadTransformer other) {
        return quad -> other.process(this.process(quad));
    }

    private static int findOffset(VertexFormatElement element) {
        int index = DefaultVertexFormat.BLOCK.getOffset(element);
        return index < 0 ? -1 : index / 4;
    }
}

