/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.obj.ObjMaterialLibrary;
import net.minecraftforge.client.model.obj.ObjModel;
import net.minecraftforge.client.model.obj.ObjTokenizer;

public class ObjLoader
implements IGeometryLoader,
ResourceManagerReloadListener {
    public static ObjLoader INSTANCE = new ObjLoader();
    private final Map<ObjModel.ModelSettings, ObjModel> modelCache = Maps.newConcurrentMap();
    private final Map<ResourceLocation, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();
    private ResourceManager manager = Minecraft.getInstance().getResourceManager();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    @Override
    public UnbakedGeometry read(JsonObject json, JsonDeserializationContext deserializationContext) {
        ResourceLocation location = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"model"));
        boolean automaticCulling = GsonHelper.getAsBoolean((JsonObject)json, (String)"automatic_culling", (boolean)true);
        boolean shadeQuads = GsonHelper.getAsBoolean((JsonObject)json, (String)"shade_quads", (boolean)true);
        boolean flipV = GsonHelper.getAsBoolean((JsonObject)json, (String)"flip_v", (boolean)false);
        boolean emissiveAmbient = GsonHelper.getAsBoolean((JsonObject)json, (String)"emissive_ambient", (boolean)true);
        String mtlOverride = GsonHelper.getAsString((JsonObject)json, (String)"mtl_override", null);
        ObjModel.ModelSettings settings = new ObjModel.ModelSettings(location, automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride);
        ObjModel model = this.loadModel(settings);
        return new ObjGeometry(model);
    }

    public ObjModel loadModel(ObjModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            ObjModel objModel;
            Resource resource = (Resource)this.manager.getResource(settings.modelLocation()).orElseThrow();
            ObjTokenizer tokenizer = new ObjTokenizer(resource.open());
            try {
                objModel = ObjModel.parse(tokenizer, settings);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return objModel;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(ResourceLocation materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            Resource resource = (Resource)this.manager.getResource(location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.open());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }

    private static class ObjGeometry
    implements UnbakedGeometry {
        private final ObjModel model;

        public ObjGeometry(ObjModel model) {
            this.model = model;
        }

        public QuadCollection bake(TextureSlots slots, ModelBaker baker, ModelState state, ModelDebugName name) {
            return this.bake(slots, baker, state, name, StandaloneGeometryBakingContext.INSTANCE);
        }

        public QuadCollection bake(TextureSlots slots, ModelBaker baker, ModelState state, ModelDebugName name, IGeometryBakingContext context) {
            QuadCollection.Builder builder = new QuadCollection.Builder();
            for (ObjModel.ModelGroup part : this.model.getParts().values()) {
                if (!context.isComponentVisible(part.name(), true)) continue;
                part.bake(slots, baker, state, name, context, builder);
            }
            return builder.build();
        }
    }
}

