/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.InputQuirks;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.jetbrains.annotations.Nullable;

public enum KeyModifier {
    CONTROL{

        @Override
        public boolean matches(InputConstants.Key key) {
            return key.getValue() == InputQuirks.EDIT_SHORTCUT_KEY_LEFT || key.getValue() == InputQuirks.EDIT_SHORTCUT_KEY_RIGHT;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return Minecraft.getInstance().hasControlDown();
        }

        @Override
        public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
            String localizationFormatKey = InputQuirks.REPLACE_CTRL_KEY_WITH_CMD_KEY ? "forge.controlsgui.control.mac" : "forge.controlsgui.control";
            return Component.translatable((String)localizationFormatKey, (Object[])new Object[]{defaultLogic.get()});
        }
    }
    ,
    SHIFT{

        @Override
        public boolean matches(InputConstants.Key key) {
            return key.getValue() == 340 || key.getValue() == 344;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return Minecraft.getInstance().hasShiftDown();
        }

        @Override
        public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
            return Component.translatable((String)"forge.controlsgui.shift", (Object[])new Object[]{defaultLogic.get()});
        }
    }
    ,
    ALT{

        @Override
        public boolean matches(InputConstants.Key key) {
            return key.getValue() == 342 || key.getValue() == 346;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return Minecraft.getInstance().hasAltDown();
        }

        @Override
        public Component getCombinedName(InputConstants.Key keyCode, Supplier<Component> defaultLogic) {
            return Component.translatable((String)"forge.controlsgui.alt", (Object[])new Object[]{defaultLogic.get()});
        }
    }
    ,
    NONE{

        @Override
        public boolean matches(InputConstants.Key key) {
            return false;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            if (conflictContext != null && !conflictContext.conflicts(KeyConflictContext.IN_GAME)) {
                for (KeyModifier keyModifier : VALUES) {
                    if (!keyModifier.isActive(conflictContext)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
            return defaultLogic.get();
        }
    };

    private static final KeyModifier[] VALUES;
    private static final List<KeyModifier> VALUES_LIST;
    private static final List<KeyModifier> ALL;

    public static final List<KeyModifier> getValues(boolean includeNone) {
        return includeNone ? ALL : VALUES_LIST;
    }

    @Nullable
    public static KeyModifier getModifier(InputConstants.Key key) {
        for (KeyModifier modifier : VALUES) {
            if (!modifier.matches(key)) continue;
            return modifier;
        }
        return null;
    }

    public static boolean isKeyCodeModifier(InputConstants.Key key) {
        for (KeyModifier keyModifier : VALUES) {
            if (!keyModifier.matches(key)) continue;
            return true;
        }
        return false;
    }

    public static KeyModifier valueFromString(String stringValue) {
        try {
            return KeyModifier.valueOf(stringValue);
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            return NONE;
        }
    }

    public abstract boolean matches(InputConstants.Key var1);

    public abstract boolean isActive(@Nullable IKeyConflictContext var1);

    public abstract Component getCombinedName(InputConstants.Key var1, Supplier<Component> var2);

    static {
        VALUES = new KeyModifier[]{SHIFT, CONTROL, ALT};
        VALUES_LIST = List.of(SHIFT, CONTROL, ALT);
        ALL = List.of(SHIFT, CONTROL, ALT, NONE);
    }
}

