/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.IntConsumer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;

public sealed interface LivingConversionEvent
extends LivingEvent,
InheritableEvent {
    public static final EventBus<LivingConversionEvent> BUS = EventBus.create(LivingConversionEvent.class);

    public static final class Post
    extends Record
    implements LivingConversionEvent {
        private final LivingEntity getEntity;
        private final LivingEntity getOutcome;
        public static final EventBus<Post> BUS = EventBus.create(Post.class);

        public Post(LivingEntity getEntity, LivingEntity getOutcome) {
            this.getEntity = getEntity;
            this.getOutcome = getOutcome;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Post.class, "getEntity;getOutcome", "getEntity", "getOutcome"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Post.class, "getEntity;getOutcome", "getEntity", "getOutcome"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Post.class, "getEntity;getOutcome", "getEntity", "getOutcome"}, this, o);
        }

        @Override
        public LivingEntity getEntity() {
            return this.getEntity;
        }

        public LivingEntity getOutcome() {
            return this.getOutcome;
        }
    }

    public static final class Pre
    implements Cancellable,
    LivingConversionEvent {
        public static final CancellableEventBus<Pre> BUS = CancellableEventBus.create(Pre.class);
        private final LivingEntity entity;
        private final EntityType<? extends LivingEntity> outcome;
        private final IntConsumer timer;

        public Pre(LivingEntity entity, EntityType<? extends LivingEntity> outcome, IntConsumer timer) {
            this.entity = entity;
            this.outcome = outcome;
            this.timer = timer;
        }

        @Override
        public LivingEntity getEntity() {
            return this.entity;
        }

        public EntityType<? extends LivingEntity> getOutcome() {
            return this.outcome;
        }

        public void setConversionTimer(int ticks) {
            this.timer.accept(ticks);
        }
    }
}

