/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class PlayerInteractEvent
implements PlayerEvent,
InheritableEvent {
    public static final EventBus<PlayerInteractEvent> BUS = EventBus.create(PlayerInteractEvent.class);
    private final Player player;
    private final InteractionHand hand;
    private final BlockPos pos;
    @Nullable
    private final Direction face;
    private InteractionResult cancellationResult = InteractionResult.PASS;

    private PlayerInteractEvent(Player player, InteractionHand hand, BlockPos pos, @Nullable Direction face) {
        this.player = Objects.requireNonNull(player, "Null player in PlayerInteractEvent!");
        this.hand = (InteractionHand)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (BlockPos)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @Override
    public Player getEntity() {
        return this.player;
    }

    @NotNull
    public InteractionHand getHand() {
        return this.hand;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.getEntity().getItemInHand(this.hand);
    }

    @NotNull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public Direction getFace() {
        return this.face;
    }

    public Level getLevel() {
        return this.getEntity().level();
    }

    public LogicalSide getSide() {
        return this.getLevel().isClientSide() ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    public InteractionResult getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(InteractionResult result) {
        this.cancellationResult = result;
    }

    public static final class LeftClickEmpty
    extends PlayerInteractEvent {
        public static final EventBus<LeftClickEmpty> BUS = EventBus.create(LeftClickEmpty.class);

        public LeftClickEmpty(Player player) {
            super(player, InteractionHand.MAIN_HAND, player.blockPosition(), null);
        }
    }

    public static final class LeftClickBlock
    extends PlayerInteractEvent
    implements Cancellable {
        public static final CancellableEventBus<LeftClickBlock> BUS = CancellableEventBus.create(LeftClickBlock.class);
        private Result useBlock = Result.DEFAULT;
        private Result useItem = Result.DEFAULT;
        private final Action action;

        @ApiStatus.Internal
        public LeftClickBlock(Player player, BlockPos pos, Direction face, Action action) {
            super(player, InteractionHand.MAIN_HAND, pos, face);
            this.action = action;
        }

        public Result getUseBlock() {
            return this.useBlock;
        }

        public Result getUseItem() {
            return this.useItem;
        }

        @NotNull
        public Action getAction() {
            return this.action;
        }

        public void setUseBlock(Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Result triggerItem) {
            this.useItem = triggerItem;
        }

        public static enum Action {
            START,
            STOP,
            ABORT,
            CLIENT_HOLD;


            public static Action convert(ServerboundPlayerActionPacket.Action action) {
                return switch (action) {
                    default -> START;
                    case ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK -> START;
                    case ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK -> STOP;
                    case ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK -> ABORT;
                };
            }
        }
    }

    public static final class RightClickEmpty
    extends PlayerInteractEvent {
        public static final EventBus<RightClickEmpty> BUS = EventBus.create(RightClickEmpty.class);

        public RightClickEmpty(Player player, InteractionHand hand) {
            super(player, hand, player.blockPosition(), null);
        }
    }

    public static final class RightClickItem
    extends PlayerInteractEvent
    implements Cancellable {
        public static final CancellableEventBus<RightClickItem> BUS = CancellableEventBus.create(RightClickItem.class);

        public RightClickItem(Player player, InteractionHand hand) {
            super(player, hand, player.blockPosition(), null);
        }
    }

    public static final class RightClickBlock
    extends PlayerInteractEvent
    implements Cancellable {
        public static final CancellableEventBus<RightClickBlock> BUS = CancellableEventBus.create(RightClickBlock.class);
        private Result useBlock = Result.DEFAULT;
        private Result useItem = Result.DEFAULT;
        private final BlockHitResult hitVec;

        public RightClickBlock(Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
            super(player, hand, pos, hitVec.getDirection());
            this.hitVec = hitVec;
        }

        public Result getUseBlock() {
            return this.useBlock;
        }

        public Result getUseItem() {
            return this.useItem;
        }

        public BlockHitResult getHitVec() {
            return this.hitVec;
        }

        public void setUseBlock(Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Result triggerItem) {
            this.useItem = triggerItem;
        }
    }

    public static final class EntityInteract
    extends PlayerInteractEvent
    implements Cancellable {
        public static final CancellableEventBus<EntityInteract> BUS = CancellableEventBus.create(EntityInteract.class);
        private final Entity target;

        public EntityInteract(Player player, InteractionHand hand, Entity target) {
            super(player, hand, target.blockPosition(), null);
            this.target = target;
        }

        public Entity getTarget() {
            return this.target;
        }
    }

    public static final class EntityInteractSpecific
    extends PlayerInteractEvent
    implements Cancellable {
        public static final CancellableEventBus<EntityInteractSpecific> BUS = CancellableEventBus.create(EntityInteractSpecific.class);
        private final Vec3 localPos;
        private final Entity target;

        public EntityInteractSpecific(Player player, InteractionHand hand, Entity target, Vec3 localPos) {
            super(player, hand, target.blockPosition(), null);
            this.localPos = localPos;
            this.target = target;
        }

        public Vec3 getLocalPos() {
            return this.localPos;
        }

        public Entity getTarget() {
            return this.target;
        }
    }
}

