/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public sealed interface DataPackRegistryEvent {

    public record DataPackRegistryData<T>(RegistryDataLoader.RegistryData<T> loaderData, @Nullable Codec<T> networkCodec) {
    }

    public static final class NewRegistry
    extends MutableEvent
    implements DataPackRegistryEvent {
        public static final EventBus<NewRegistry> BUS = EventBus.create(NewRegistry.class);
        private final List<DataPackRegistryData<?>> registryDataList = new ArrayList();

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<NewRegistry> getBus(BusGroup modBusGroup) {
            return BUS;
        }

        @ApiStatus.Internal
        public NewRegistry() {
        }

        public <T> void dataPackRegistry(ResourceKey<Registry<T>> registryKey, Codec<T> codec) {
            this.dataPackRegistry(registryKey, codec, null);
        }

        public <T> void dataPackRegistry(ResourceKey<Registry<T>> registryKey, Codec<T> codec, @Nullable Codec<T> networkCodec) {
            this.registryDataList.add(new DataPackRegistryData<T>(new RegistryDataLoader.RegistryData(registryKey, codec, false), networkCodec));
        }

        void process() {
            for (DataPackRegistryData<?> registryData : this.registryDataList) {
                DataPackRegistriesHooks.addRegistryCodec(registryData);
            }
        }
    }
}

