/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.RandomSource;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NamespacedWrapper<T>
extends MappedRegistry<T>
implements ILockableRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = ForgeRegistry.REGISTRIES;
    private final ForgeRegistry<T> delegate;
    @Nullable
    private final Function<T, Holder.Reference<T>> intrusiveHolderCallback;
    private final Multimap<TagKey<T>, Supplier<T>> optionalTags = Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new);
    boolean locked = false;
    Lifecycle registryLifecycle = Lifecycle.stable();
    private boolean frozen = false;
    private List<Holder.Reference<T>> holdersSorted;
    private final ObjectList<Holder.Reference<T>> holdersById = new ObjectArrayList(256);
    private final Map<ResourceLocation, Holder.Reference<T>> holdersByName = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> holders = new IdentityHashMap<T, Holder.Reference<T>>();
    private final RegistryManager stage;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> registrationInfos = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private MappedRegistry.TagSet<T> frozenTags = MappedRegistry.TagSet.unbound();

    NamespacedWrapper(ForgeRegistry<T> fowner, Function<T, Holder.Reference<T>> intrusiveHolderCallback, RegistryManager stage) {
        super(fowner.getRegistryKey(), Lifecycle.stable(), intrusiveHolderCallback != null);
        this.delegate = fowner;
        this.intrusiveHolderCallback = intrusiveHolderCallback;
        this.stage = stage;
    }

    public Holder.Reference<T> register(ResourceKey<T> key, T value, RegistrationInfo info) {
        if (this.locked) {
            throw new IllegalStateException("Can not register to a locked registry. Modder should use Forge Register methods.");
        }
        Objects.requireNonNull(value);
        this.markKnown();
        this.registrationInfos.put(key, info);
        this.registryLifecycle = this.registryLifecycle.add(info.lifecycle());
        this.delegate.add(-1, key.location(), value);
        return this.getHolder(key, value);
    }

    @Nullable
    public T getValue(@Nullable ResourceLocation name) {
        return this.delegate.getRaw(name);
    }

    public Optional<T> getOptional(@Nullable ResourceLocation name) {
        return Optional.ofNullable(this.delegate.getRaw(name));
    }

    @Nullable
    public T getValue(@Nullable ResourceKey<T> name) {
        return name == null ? null : (T)this.delegate.getRaw(name.location());
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return this.delegate.getKey(value);
    }

    public Optional<ResourceKey<T>> getResourceKey(T value) {
        return this.delegate.getResourceKey(value);
    }

    public boolean containsKey(ResourceLocation key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsKey(ResourceKey<T> key) {
        return this.delegate.getRegistryName().equals((Object)key.registry()) && this.containsKey(key.location());
    }

    public int getId(@Nullable T value) {
        return this.delegate.getID(value);
    }

    @Nullable
    public T byId(int id) {
        return this.delegate.getValue(id);
    }

    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public Set<ResourceLocation> keySet() {
        return this.delegate.getKeys();
    }

    public Set<ResourceKey<T>> registryKeySet() {
        return this.delegate.getResourceKeys();
    }

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return this.delegate.getEntries();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    @Deprecated
    public void lock() {
        this.locked = true;
    }

    public Optional<Holder.Reference<T>> get(int id) {
        return id >= 0 && id < this.holdersById.size() ? Optional.ofNullable((Holder.Reference)this.holdersById.get(id)) : Optional.empty();
    }

    public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
        return Optional.ofNullable(this.holdersByName.get(key.location()));
    }

    public Optional<Holder.Reference<T>> get(ResourceLocation p_333710_) {
        return Optional.ofNullable(this.holdersByName.get(p_333710_));
    }

    @NotNull
    public Holder<T> wrapAsHolder(@NotNull T value) {
        Holder holder = (Holder)this.holders.get(value);
        return holder == null ? Holder.direct(value) : holder;
    }

    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> p_331530_) {
        return Optional.ofNullable(this.registrationInfos.get(p_331530_));
    }

    public Optional<Holder.Reference<T>> getHolder(ResourceLocation location) {
        return Optional.ofNullable(this.holdersByName.get(location));
    }

    Optional<Holder<T>> getHolder(T value) {
        return Optional.ofNullable((Holder)this.holders.get(value));
    }

    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
                return Optional.of(this.getOrThrow(key));
            }

            public Holder.Reference<T> getOrThrow(ResourceKey<T> key) {
                return NamespacedWrapper.this.getOrCreateHolderOrThrow(key);
            }

            public Optional<HolderSet.Named<T>> get(TagKey<T> key) {
                return Optional.of(this.getOrThrow(key));
            }

            public HolderSet.Named<T> getOrThrow(TagKey<T> key) {
                return NamespacedWrapper.this.getOrCreateTagForRegistration(key);
            }
        };
    }

    void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry " + String.valueOf(this.key().location()) + " is already frozen");
        }
    }

    void validateWrite(ResourceKey<T> key) {
        if (this.frozen) {
            throw new IllegalStateException("Registry " + String.valueOf(this.key().location()) + " is already frozen (trying to add key " + String.valueOf(key) + ")");
        }
    }

    protected Holder.Reference<T> getOrCreateHolderOrThrow(ResourceKey<T> key) {
        return this.holdersByName.computeIfAbsent(key.location(), k -> {
            if (this.isIntrusive()) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite(key);
            return Holder.Reference.createStandAlone((HolderOwner)this, (ResourceKey)key);
        });
    }

    public Optional<Holder.Reference<T>> getRandom(RandomSource rand) {
        return Util.getRandomSafe(this.getSortedHolders(), (RandomSource)rand);
    }

    public Stream<Holder.Reference<T>> listElements() {
        return this.getSortedHolders().stream();
    }

    public Stream<HolderSet.Named<T>> getTags() {
        return this.frozenTags.getTags();
    }

    public HolderSet.Named<T> getOrCreateTagForRegistration(TagKey<T> name) {
        return this.tags.computeIfAbsent(name, this::createTag);
    }

    void addOptionalTag(TagKey<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        this.optionalTags.putAll(name, defaults);
    }

    public Registry<T> freeze() {
        if (this.frozen) {
            return this;
        }
        this.frozen = true;
        List<ResourceLocation> unregistered = this.holdersByName.entrySet().stream().filter(e -> !((Holder.Reference)e.getValue()).isBound()).map(Map.Entry::getKey).sorted().toList();
        if (!unregistered.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + unregistered.stream().map(ResourceLocation::toString).collect(Collectors.joining(", \n\t")));
        }
        if (this.unregisteredIntrusiveHolders != null && this.unregisteredIntrusiveHolders.values().stream().anyMatch(r -> !r.isBound() && r.getType() == Holder.Reference.Type.INTRUSIVE)) {
            throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()) + " Hint: Did you register all your registry objects? Registry stage: " + this.stage.getName());
        }
        if (this.frozenTags.isBound()) {
            throw new IllegalStateException("Tags already present before freezing");
        }
        List<ResourceLocation> unbound = this.tags.entrySet().stream().filter(t -> !((HolderSet.Named)t.getValue()).isBound()).map(t -> ((TagKey)t.getKey()).location()).sorted().toList();
        if (!unbound.isEmpty()) {
            LOGGER.debug(MARKER, "Unbound tags in registry " + String.valueOf(this.key()) + ": " + String.valueOf(unbound));
            this.bindAllUnboundTagsToEmpty();
        }
        this.frozenTags = MappedRegistry.TagSet.fromMap(this.tags);
        this.delegate.onBindTags(this.tags);
        this.refreshTagsInHoldersForge();
        return this;
    }

    private void refreshTagsInHoldersForge() {
        IdentityHashMap map = new IdentityHashMap();
        for (Holder.Reference<T> reference : this.holdersByName.values()) {
            map.put(reference, new ArrayList());
        }
        this.frozenTags.forEach((key, value) -> {
            for (Holder holder : value) {
                Holder.Reference<T> reference = this.validateAndUnwrapTagElement((TagKey<T>)key, (Holder<T>)holder);
                ((List)map.get(reference)).add(key);
            }
        });
        for (Map.Entry entry : map.entrySet()) {
            ((Holder.Reference)entry.getKey()).bindTags((Collection)entry.getValue());
        }
    }

    private Holder.Reference<T> validateAndUnwrapTagElement(TagKey<T> key, Holder<T> value) {
        if (!value.canSerializeIn((HolderOwner)this)) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(key) + " containing value " + String.valueOf(value) + " from outside registry " + String.valueOf(this));
        }
        if (value instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)value;
            return reference;
        }
        throw new IllegalStateException("Found direct holder " + String.valueOf(value) + " value in tag " + String.valueOf(key));
    }

    public Holder.Reference<T> createIntrusiveHolder(T value) {
        if (!this.isIntrusive()) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return super.createIntrusiveHolder(value);
    }

    public Optional<HolderSet.Named<T>> get(TagKey<T> name) {
        return this.frozenTags.get(name);
    }

    public void bindTag(TagKey<T> key, List<Holder<T>> newTags) {
        this.validateWrite();
        this.getOrCreateTagForRegistration(key).bind(newTags);
    }

    public void bindAllTagsToEmpty() {
        this.validateWrite();
        for (HolderSet.Named<T> tag : this.tags.values()) {
            tag.bind(List.of());
        }
    }

    private void bindAllUnboundTagsToEmpty() {
        for (HolderSet.Named<T> tag : this.tags.values()) {
            if (tag.isBound()) continue;
            tag.bind(List.of());
        }
    }

    public Registry.PendingTags<T> prepareTagReload(TagLoader.LoadResult<T> data) {
        TagKey key;
        if (!this.frozen) {
            throw new IllegalStateException("Invalid method used for tag loading");
        }
        ImmutableMap.Builder _old = ImmutableMap.builder();
        ImmutableMap.Builder _new = ImmutableMap.builder();
        for (Map.Entry entry : data.tags().entrySet()) {
            key = (TagKey)entry.getKey();
            HolderSet.Named<T> existing = this.tags.get(key);
            if (existing == null) {
                existing = this.createTag(key);
            }
            _old.put((Object)key, existing);
            _new.put((Object)key, List.copyOf((Collection)entry.getValue()));
        }
        for (Map.Entry entry : this.optionalTags.entries()) {
            Object value;
            Holder holder;
            key = (TagKey)entry.getKey();
            if (data.tags().containsKey(key) || (holder = (Holder)this.getHolder(value = ((Supplier)entry.getValue()).get()).orElse(null)) == null) continue;
            HolderSet.Named<T> existing = this.tags.get(key);
            if (existing == null) {
                existing = this.createTag(key);
            }
            _old.put((Object)key, existing);
            _new.put((Object)key, List.of(holder));
        }
        final ImmutableMap oldBindings = _old.build();
        final ImmutableMap newBindings = _new.build();
        HolderLookup.RegistryLookup.Delegate oldSnapshot = new HolderLookup.RegistryLookup.Delegate<T>(){

            public HolderLookup.RegistryLookup<T> parent() {
                return NamespacedWrapper.this;
            }

            public Optional<HolderSet.Named<T>> get(TagKey<T> p_259486_) {
                return Optional.ofNullable((HolderSet.Named)oldBindings.get(p_259486_));
            }

            public Stream<HolderSet.Named<T>> listTags() {
                return oldBindings.values().stream();
            }
        };
        return new Registry.PendingTags<T>(){
            final /* synthetic */ 2 val$oldSnapshot;
            final /* synthetic */ ImmutableMap val$oldBindings;
            {
                this.val$oldSnapshot = var3_3;
                this.val$oldBindings = immutableMap2;
            }

            public ResourceKey<? extends Registry<? extends T>> key() {
                return NamespacedWrapper.this.key();
            }

            public int size() {
                return newBindings.size();
            }

            public HolderLookup.RegistryLookup<T> lookup() {
                return this.val$oldSnapshot;
            }

            public List<Holder<T>> getPending(TagKey<T> key) {
                return (List)newBindings.getOrDefault(key, List.of());
            }

            public void apply() {
                for (Map.Entry entry : this.val$oldBindings.entrySet()) {
                    List newList = (List)newBindings.getOrDefault(entry.getKey(), List.of());
                    ((HolderSet.Named)entry.getValue()).bind(newList);
                }
                NamespacedWrapper.this.frozenTags = MappedRegistry.TagSet.fromMap((Map)this.val$oldBindings);
                NamespacedWrapper.this.delegate.onBindTags(NamespacedWrapper.this.tags);
                NamespacedWrapper.this.refreshTagsInHoldersForge();
            }
        };
    }

    public void unfreeze() {
        this.frozen = false;
        this.frozenTags = MappedRegistry.TagSet.unbound();
    }

    boolean isFrozen() {
        return this.frozen;
    }

    public boolean isIntrusive() {
        return this.intrusiveHolderCallback != null && this.stage == RegistryManager.ACTIVE;
    }

    @Nullable
    Holder.Reference<T> onAdded(RegistryManager stage, int id, ResourceKey<T> key, T newValue, T oldValue) {
        Holder.Reference<T> newHolder = this.getHolder(key, newValue);
        this.holdersById.size(Math.max(this.holdersById.size(), id + 1));
        this.holdersById.set(id, newHolder);
        this.holdersByName.put(key.location(), newHolder);
        this.holders.put(newValue, newHolder);
        if (this.unregisteredIntrusiveHolders != null) {
            this.unregisteredIntrusiveHolders.remove(newValue);
            newHolder.bindKey(key);
        }
        newHolder.bindValue(newValue);
        this.holdersSorted = null;
        return newHolder;
    }

    private HolderSet.Named<T> createTag(TagKey<T> name) {
        return new HolderSet.Named((HolderOwner)this, name);
    }

    private Holder.Reference<T> getHolder(ResourceKey<T> key, T value) {
        if (this.isIntrusive()) {
            return this.intrusiveHolderCallback.apply(value);
        }
        return this.holdersByName.computeIfAbsent(key.location(), k -> Holder.Reference.createStandAlone((HolderOwner)this, (ResourceKey)key));
    }

    private List<Holder.Reference<T>> getSortedHolders() {
        if (this.holdersSorted == null) {
            this.holdersSorted = this.holdersById.stream().filter(Objects::nonNull).toList();
        }
        return this.holdersSorted;
    }
}

