/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraftforge.client.event.RegisterPresetEditorsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class PresetEditorManager {
    private static Map<ResourceKey<WorldPreset>, PresetEditor> editors = Map.of();

    private PresetEditorManager() {
    }

    @ApiStatus.Internal
    static void init() {
        HashMap<ResourceKey<WorldPreset>, PresetEditor> gatheredEditors = new HashMap<ResourceKey<WorldPreset>, PresetEditor>();
        for (Map.Entry entry : PresetEditor.EDITORS.entrySet()) {
            ResourceKey key = ((Optional)entry.getKey()).orElse(null);
            if (key == null) continue;
            gatheredEditors.put((ResourceKey<WorldPreset>)key, (PresetEditor)entry.getValue());
        }
        RegisterPresetEditorsEvent event = new RegisterPresetEditorsEvent(gatheredEditors);
        ModLoader.get().postEventWrapContainerInModOrder((Event)event);
        editors = gatheredEditors;
    }

    @Nullable
    public static PresetEditor get(ResourceKey<WorldPreset> key) {
        return editors.get(key);
    }
}

