/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.unsafe.UnsafeFieldAccess;
import net.minecraftforge.unsafe.UnsafeHacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ForgeRecipeProvider
extends VanillaRecipeProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HolderLookup.RegistryLookup<Item> items;
    private final Map<Item, TagKey<Item>> replacements = HashMap.newHashMap(12);
    private final Set<ResourceKey<Recipe<?>>> excludes = HashSet.newHashSet(16);
    private final UnsafeFieldAccess<ShapelessRecipe, List<Ingredient>> INGREDIENTS = UnsafeHacks.findField(ShapelessRecipe.class, (String)"ingredients");
    private final UnsafeFieldAccess<ShapedRecipe, ShapedRecipePattern> PATTERN = UnsafeHacks.findField(ShapedRecipe.class, (String)"pattern");
    private final UnsafeFieldAccess<Ingredient, HolderSet<Item>> VALUES = UnsafeHacks.findField(Ingredient.class, (String)"values");

    private ForgeRecipeProvider(HolderLookup.Provider lookup, RecipeOutput output) {
        super(lookup, (RecipeOutput)new Wrapped(output));
        ((Wrapped)this.output).setSelf(this);
        this.items = lookup.lookupOrThrow(Registries.ITEM);
    }

    private void exclude(ItemLike item) {
        this.exclude(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).toString());
    }

    private void exclude(String name) {
        this.excludes.add(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)name)));
    }

    private void replace(ItemLike item, TagKey<Item> tag) {
        this.replacements.put(item.asItem(), tag);
    }

    protected void buildRecipes() {
        this.replace((ItemLike)Items.STICK, Tags.Items.RODS_WOODEN);
        this.replace((ItemLike)Items.GOLD_INGOT, Tags.Items.INGOTS_GOLD);
        this.replace((ItemLike)Items.IRON_INGOT, Tags.Items.INGOTS_IRON);
        this.replace((ItemLike)Items.NETHERITE_INGOT, Tags.Items.INGOTS_NETHERITE);
        this.replace((ItemLike)Items.COPPER_INGOT, Tags.Items.INGOTS_COPPER);
        this.replace((ItemLike)Items.AMETHYST_SHARD, Tags.Items.GEMS_AMETHYST);
        this.replace((ItemLike)Items.DIAMOND, Tags.Items.GEMS_DIAMOND);
        this.replace((ItemLike)Items.EMERALD, Tags.Items.GEMS_EMERALD);
        this.replace((ItemLike)Items.CHEST, Tags.Items.CHESTS_WOODEN);
        this.replace((ItemLike)Blocks.COBBLESTONE, Tags.Items.COBBLESTONE_NORMAL);
        this.replace((ItemLike)Blocks.COBBLED_DEEPSLATE, Tags.Items.COBBLESTONE_DEEPSLATE);
        this.replace((ItemLike)Items.STRING, Tags.Items.STRINGS);
        this.exclude(ForgeRecipeProvider.getConversionRecipeName((ItemLike)Blocks.WHITE_WOOL, (ItemLike)Items.STRING));
        this.exclude((ItemLike)Blocks.GOLD_BLOCK);
        this.exclude((ItemLike)Items.GOLD_NUGGET);
        this.exclude((ItemLike)Blocks.IRON_BLOCK);
        this.exclude((ItemLike)Items.IRON_NUGGET);
        this.exclude((ItemLike)Blocks.DIAMOND_BLOCK);
        this.exclude((ItemLike)Blocks.EMERALD_BLOCK);
        this.exclude((ItemLike)Blocks.NETHERITE_BLOCK);
        this.exclude((ItemLike)Blocks.COPPER_BLOCK);
        this.exclude((ItemLike)Blocks.AMETHYST_BLOCK);
        this.exclude((ItemLike)Blocks.COBBLESTONE_STAIRS);
        this.exclude((ItemLike)Blocks.COBBLESTONE_SLAB);
        this.exclude((ItemLike)Blocks.COBBLESTONE_WALL);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_STAIRS);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_SLAB);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_WALL);
        super.buildRecipes();
    }

    @Nullable
    private Recipe<?> enhance(ResourceKey<Recipe<?>> id, Recipe<?> vanilla) {
        if (vanilla instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)vanilla;
            return this.enhance(id, shapeless);
        }
        if (vanilla instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)vanilla;
            return this.enhance(id, shaped);
        }
        return null;
    }

    @Nullable
    private Recipe<?> enhance(ResourceKey<Recipe<?>> id, ShapelessRecipe vanilla) {
        List ingredients = (List)this.INGREDIENTS.get((Object)vanilla);
        boolean modified = false;
        for (int x = 0; x < ingredients.size(); ++x) {
            Ingredient ing = this.enhance(id, (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.set(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    @Nullable
    private Recipe<?> enhance(ResourceKey<Recipe<?>> id, ShapedRecipe vanilla) {
        ShapedRecipePattern pattern = (ShapedRecipePattern)this.PATTERN.get((Object)vanilla);
        ShapedRecipePattern.Data data = (ShapedRecipePattern.Data)pattern.data().orElseThrow(() -> new IllegalStateException("Weird shaped recipe, data is missing? " + String.valueOf(id) + " " + String.valueOf(vanilla)));
        Map ingredients = data.key();
        boolean modified = false;
        for (Character x : ingredients.keySet()) {
            Ingredient ing = this.enhance(id, (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.put(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    @Nullable
    private Ingredient enhance(ResourceKey<Recipe<?>> name, Ingredient vanilla) {
        if (this.excludes.contains(name)) {
            return null;
        }
        HolderSet vanillaItems = (HolderSet)this.VALUES.get((Object)vanilla);
        Either unwraped = vanillaItems.unwrap();
        if (unwraped.left().isPresent()) {
            return null;
        }
        Ingredient ret = null;
        ArrayList<Holder> items = new ArrayList<Holder>();
        for (Holder entry : (List)unwraped.right().get()) {
            Item item = (Item)entry.get();
            TagKey<Item> replacement = this.replacements.get(item);
            if (replacement != null) {
                if (ret != null) {
                    LOGGER.warn("Failed to enahnce {} ingredient has multiple input items", name);
                    return null;
                }
                ret = Ingredient.of((HolderSet)this.items.getOrThrow(replacement));
                continue;
            }
            items.add(entry);
        }
        if (ret != null && !items.isEmpty()) {
            LOGGER.warn("Failed to enahnce {} ingredient has multiple input items", name);
            return null;
        }
        return ret;
    }

    private static class Wrapped
    implements RecipeOutput {
        private final RecipeOutput wrapped;
        private ForgeRecipeProvider self;

        private Wrapped(RecipeOutput wrapped) {
            this.wrapped = wrapped;
        }

        private void setSelf(ForgeRecipeProvider self) {
            this.self = self;
        }

        public void accept(ResourceKey<Recipe<?>> id, Recipe<?> recipe, AdvancementHolder advancement) {
            Recipe<?> modified = this.self.enhance(id, recipe);
            if (modified != null) {
                this.wrapped.accept(id, modified, null);
            }
        }

        public Advancement.Builder advancement() {
            return this.wrapped.advancement();
        }

        public void accept(ResourceKey<Recipe<?>> id, Recipe<?> recipe, ResourceLocation advancementId, JsonElement advancement) {
            Recipe<?> modified = this.self.enhance(id, recipe);
            if (modified != null) {
                this.wrapped.accept(id, modified, null);
            }
        }

        public HolderLookup.Provider registry() {
            return this.wrapped.registry();
        }

        public void includeRootAdvancement() {
        }
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        public String getName() {
            return ForgeRecipeProvider.class.getSimpleName();
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new ForgeRecipeProvider(registries, output);
        }
    }
}

