/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.mojang.authlib.GameProfile;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public interface IForgeGameTestHelper {
    private GameTestHelper self() {
        return (GameTestHelper)this;
    }

    default public void say(String message) {
        this.say(message, Style.EMPTY);
    }

    default public void say(String message, Style style) {
        this.say((Component)this.getMessage(message).withStyle(style));
    }

    default public void say(String message, ChatFormatting style) {
        this.say((Component)this.getMessage(message).withStyle(style));
    }

    default public void say(String message, int color) {
        this.say((Component)this.getMessage(message).withColor(color));
    }

    default public void say(Component component) {
        this.self().getLevel().players().forEach(p -> p.sendSystemMessage(component));
    }

    private MutableComponent getMessage(String message) {
        return ForgeI18n.getPattern(message) != null ? Component.translatable((String)message) : Component.literal((String)message);
    }

    default public void assertTrue(boolean value, Supplier<String> message) {
        if (!value) {
            throw new GameTestAssertException(message.get());
        }
    }

    default public void assertFalse(boolean value, Supplier<String> message) {
        if (value) {
            throw new GameTestAssertException(message.get());
        }
    }

    default public <N> void assertValueEqual(N expected, N actual, String name, String message) {
        this.assertValueEqual(expected, actual, name, () -> message);
    }

    default public <N> void assertValueEqual(N expected, N actual, String name, Supplier<String> message) {
        if (!Objects.equals(expected, actual)) {
            throw new GameTestAssertException("%s -- Expected %s to be %s, but was %s".formatted(message.get(), name, expected, actual));
        }
    }

    default public <N> void assertValueEqual(N[] expected, N[] actual, String name, String message) {
        this.assertValueEqual(expected, actual, name, () -> message);
    }

    default public <N> void assertValueEqual(N[] expected, N[] actual, String name, Supplier<String> message) {
        if (!Objects.deepEquals(expected, actual)) {
            throw new GameTestAssertException("%s -- Expected %s to be %s, but was %s".formatted(message.get(), name, Arrays.toString(expected), Arrays.toString(actual)));
        }
    }

    default public <N> void assertValueNotEqual(N expected, N actual, String name, String message) {
        this.assertValueNotEqual(expected, actual, name, () -> message);
    }

    default public <N> void assertValueNotEqual(N expected, N actual, String name, Supplier<String> message) {
        if (Objects.equals(expected, actual)) {
            throw new GameTestAssertException("%s -- Expected %s to NOT be %s, but was".formatted(message.get(), name, expected));
        }
    }

    default public <N> void assertValueNotEqual(N[] expected, N[] actual, String name, String message) {
        this.assertValueNotEqual(expected, actual, name, () -> message);
    }

    default public <N> void assertValueNotEqual(N[] expected, N[] actual, String name, Supplier<String> message) {
        if (!Objects.deepEquals(expected, actual)) {
            throw new GameTestAssertException("%s -- Expected %s to NOT be %s, but was".formatted(message.get(), name, Arrays.toString(expected)));
        }
    }

    default public <E> Registry<E> registryLookup(ResourceKey<? extends Registry<? extends E>> registryKey) {
        return this.self().getLevel().registryAccess().lookupOrThrow(registryKey);
    }

    default public ServerPlayer makeMockServerPlayer() {
        return this.makeMockServerPlayer(true);
    }

    default public ServerPlayer makeMockServerPlayer(final boolean creative) {
        ServerLevel level = this.self().getLevel();
        CommonListenerCookie cookie = CommonListenerCookie.createInitial((GameProfile)new GameProfile(UUID.randomUUID(), "test-mock-player"), (boolean)false);
        ServerPlayer player = new ServerPlayer(this, level.getServer(), level, cookie.gameProfile(), cookie.clientInformation()){

            public boolean isSpectator() {
                return false;
            }

            public boolean isCreative() {
                return creative;
            }
        };
        Connection connection = new Connection(PacketFlow.SERVERBOUND);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{connection});
        MinecraftServer server = level.getServer();
        ServerGamePacketListenerImpl listener = new ServerGamePacketListenerImpl(server, connection, player, cookie);
        ProtocolInfo info = GameProtocols.SERVERBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator((RegistryAccess)server.registryAccess()));
        connection.setupInboundProtocol(info, (PacketListener)listener);
        return player;
    }

    default public <E extends Event> void addEventListener(Consumer<E> consumer) {
        MinecraftForge.EVENT_BUS.addListener(consumer);
        this.self().addCleanup(success -> MinecraftForge.EVENT_BUS.unregister((Object)consumer));
    }

    default public void registerEventListener(Object handler) {
        MinecraftForge.EVENT_BUS.register(handler);
        this.self().addCleanup(success -> MinecraftForge.EVENT_BUS.unregister(handler));
    }

    default public void makeFloor() {
        this.makeFloor(Blocks.STONE);
    }

    default public void makeFloor(Block block) {
        this.makeFloor(block, -1);
    }

    default public void makeFloor(Block block, int height) {
        AABB bounds = this.self().getBounds();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < (int)bounds.getXsize(); ++x) {
            for (int y = 0; y < (int)bounds.getZsize(); ++y) {
                pos.set(x, height, y);
                if (!this.self().getBlockState((BlockPos)pos).is(Blocks.AIR)) continue;
                this.self().setBlock((BlockPos)pos, block);
            }
        }
    }

    default public void setAndAssertBlock(int x, int y, int z, Block block) {
        this.setAssertAndGetBlock(x, y, z, block);
    }

    default public void setAndAssertBlock(int x, int y, int z, BlockState state) {
        this.setAssertAndGetBlock(x, y, z, state);
    }

    default public void setAndAssertBlock(BlockPos pos, Block block) {
        this.setAssertAndGetBlock(pos, block);
    }

    default public void setAndAssertBlock(BlockPos pos, BlockState state) {
        this.setAssertAndGetBlock(pos, state);
    }

    default public BlockState setAssertAndGetBlock(int x, int y, int z, Block block) {
        return this.setAssertAndGetBlock(x, y, z, block.defaultBlockState());
    }

    default public BlockState setAssertAndGetBlock(int x, int y, int z, BlockState state) {
        return this.setAssertAndGetBlock(new BlockPos(x, y, z), state);
    }

    default public BlockState setAssertAndGetBlock(BlockPos pos, Block block) {
        return this.setAssertAndGetBlock(pos, block.defaultBlockState());
    }

    default public BlockState setAssertAndGetBlock(BlockPos pos, BlockState state) {
        this.assertTrue(this.self().getLevel().setBlock(this.self().absolutePos(pos), state, 3), () -> "Failed to set block at pos %s : %s".formatted(pos, state.getBlock()));
        return state;
    }

    default public void removeAllItemEntitiesInRange(BlockPos pos, double range) {
        BlockPos blockpos = this.self().absolutePos(pos);
        for (ItemEntity itemEntity : this.self().getLevel().getEntities((EntityTypeTest)EntityType.ITEM, new AABB(blockpos).inflate(range), Entity::isAlive)) {
            itemEntity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public <T> Flag<T> flag(String name) {
        return new Flag(name);
    }

    default public IntFlag intFlag(String name) {
        return new IntFlag(name);
    }

    default public IntFlag intFlag(String name, int value) {
        return this.intFlag(name, (long)value);
    }

    default public IntFlag intFlag(String name, long value) {
        return (IntFlag)Util.make((Object)new IntFlag(name), flag -> flag.set(value));
    }

    default public BoolFlag boolFlag(String name) {
        return new BoolFlag(name);
    }

    public static class Flag<T> {
        private final String name;
        @Nullable
        protected T value = null;

        public Flag(String name) {
            this.name = name;
        }

        public void set(T value) {
            this.value = value;
        }

        @Nullable
        public T get() {
            return this.value;
        }

        public void assertUnset() {
            this.assertUnset((Supplier<String>)null);
        }

        public void assertUnset(String message) {
            this.assertUnset(message != null ? () -> message : null);
        }

        public void assertUnset(Supplier<String> message) {
            if (this.value != null) {
                String s = message != null ? message.get() + " -- " : "";
                throw new GameTestAssertException(s + "Expected " + this.name + " to be null, but was " + String.valueOf(this.value));
            }
        }

        public void assertSet() {
            this.assertSet((Supplier<String>)null);
        }

        public void assertSet(String message) {
            this.assertSet(message != null ? () -> message : null);
        }

        public void assertSet(Supplier<String> message) {
            if (this.value == null) {
                String s = message != null ? message.get() + " -- " : "";
                throw new GameTestAssertException(s + "Flag " + this.name + " was never set");
            }
        }

        public void assertEquals(T expected) {
            this.assertEquals(expected, (Supplier<String>)null);
        }

        public void assertEquals(T expected, String message) {
            this.assertEquals(expected, message != null ? () -> message : null);
        }

        public void assertEquals(T expected, Supplier<String> message) {
            this.assertSet(message);
            if (expected != null && !expected.equals(this.value)) {
                String s = message != null ? message.get() + " -- " : "";
                throw new GameTestAssertException(s + "Expected " + this.name + " to be " + String.valueOf(expected) + ", but was " + String.valueOf(this.value));
            }
        }
    }

    public static class IntFlag
    extends Flag<Long> {
        public IntFlag(String name) {
            super(name);
        }

        @Override
        public void set(long value) {
            super.set(value);
        }

        public void increment() {
            this.decrement(1L);
        }

        public void increment(int amount) {
            this.decrement((long)amount);
        }

        public void increment(long amount) {
            if (this.value != null) {
                this.set((Long)this.value + amount);
            }
        }

        public void decrement() {
            this.decrement(1L);
        }

        public void decrement(int amount) {
            this.decrement((long)amount);
        }

        public void decrement(long amount) {
            if (this.value != null) {
                this.set((Long)this.value - amount);
            }
        }

        public byte getByte() {
            return this.value == null ? (byte)-1 : ((Long)this.value).byteValue();
        }

        public int getInt() {
            return this.value == null ? -1 : ((Long)this.value).intValue();
        }

        public long getLong() {
            return this.value == null ? -1L : (Long)this.value;
        }

        @Override
        public void assertEquals(int expected) {
            super.assertEquals(Long.valueOf(expected));
        }

        @Override
        public void assertEquals(long expected) {
            super.assertEquals(expected);
        }

        @Override
        public void assertEquals(int expected, String message) {
            super.assertEquals(Long.valueOf(expected), message);
        }

        @Override
        public void assertEquals(long expected, String message) {
            super.assertEquals(Long.valueOf(expected), message);
        }

        @Override
        public void assertEquals(int expected, Supplier<String> message) {
            super.assertEquals(Long.valueOf(expected), message);
        }

        @Override
        public void assertEquals(long expected, Supplier<String> message) {
            super.assertEquals(Long.valueOf(expected), message);
        }
    }

    public static class BoolFlag
    extends Flag<Boolean> {
        public BoolFlag(String name) {
            super(name);
        }

        @Override
        public void set(boolean value) {
            super.set(value);
        }

        public boolean getBool() {
            return this.value != null && (Boolean)this.value != false;
        }

        @Override
        public void assertEquals(boolean expected) {
            super.assertEquals(expected);
        }

        @Override
        public void assertEquals(boolean expected, String message) {
            super.assertEquals(Boolean.valueOf(expected), message);
        }

        @Override
        public void assertEquals(boolean expected, Supplier<String> message) {
            super.assertEquals(Boolean.valueOf(expected), message);
        }
    }
}

