/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.function.BooleanSupplier;
import net.minecraft.client.DeltaTracker;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class TickEvent
extends Event {
    public final Type type;
    public final LogicalSide side;
    public final Phase phase;

    public TickEvent(Type type, LogicalSide side, Phase phase) {
        this.type = type;
        this.side = side;
        this.phase = phase;
    }

    public static enum Type {
        LEVEL,
        PLAYER,
        CLIENT,
        SERVER,
        RENDER;

    }

    public static enum Phase {
        START,
        END;

    }

    public static class RenderTickEvent
    extends TickEvent {
        private final DeltaTracker timer;

        private RenderTickEvent(Phase phase, DeltaTracker timer) {
            super(Type.RENDER, LogicalSide.CLIENT, phase);
            this.timer = timer;
        }

        public DeltaTracker getTimer() {
            return this.timer;
        }

        public static class Post
        extends RenderTickEvent {
            public Post(DeltaTracker timer) {
                super(Phase.END, timer);
            }
        }

        public static class Pre
        extends RenderTickEvent {
            public Pre(DeltaTracker timer) {
                super(Phase.START, timer);
            }
        }
    }

    public static class PlayerTickEvent
    extends TickEvent {
        public final Player player;

        protected PlayerTickEvent(Player player, Phase phase) {
            super(Type.PLAYER, player instanceof ServerPlayer ? LogicalSide.SERVER : LogicalSide.CLIENT, phase);
            this.player = player;
        }

        public static class Post
        extends PlayerTickEvent {
            public Post(Player player) {
                super(player, Phase.END);
            }
        }

        public static class Pre
        extends PlayerTickEvent {
            public Pre(Player player) {
                super(player, Phase.START);
            }
        }
    }

    public static class LevelTickEvent
    extends TickEvent {
        public final Level level;
        private final BooleanSupplier haveTime;

        protected LevelTickEvent(LogicalSide side, Level level, BooleanSupplier haveTime, Phase phase) {
            super(Type.LEVEL, side, phase);
            this.level = level;
            this.haveTime = haveTime;
        }

        public boolean haveTime() {
            return this.haveTime.getAsBoolean();
        }

        public static class Post
        extends LevelTickEvent {
            public Post(LogicalSide side, Level level, BooleanSupplier haveTime) {
                super(side, level, haveTime, Phase.END);
            }
        }

        public static class Pre
        extends LevelTickEvent {
            public Pre(LogicalSide side, Level level, BooleanSupplier haveTime) {
                super(side, level, haveTime, Phase.START);
            }
        }
    }

    public static class ClientTickEvent
    extends TickEvent {
        protected ClientTickEvent(Phase phase) {
            super(Type.CLIENT, LogicalSide.CLIENT, phase);
        }

        public static class Post
        extends ClientTickEvent {
            public Post() {
                super(Phase.END);
            }
        }

        public static class Pre
        extends ClientTickEvent {
            public Pre() {
                super(Phase.START);
            }
        }
    }

    public static class ServerTickEvent
    extends TickEvent {
        private final BooleanSupplier haveTime;
        private final MinecraftServer server;

        protected ServerTickEvent(BooleanSupplier haveTime, MinecraftServer server, Phase phase) {
            super(Type.SERVER, LogicalSide.SERVER, phase);
            this.haveTime = haveTime;
            this.server = server;
        }

        public boolean haveTime() {
            return this.haveTime.getAsBoolean();
        }

        public MinecraftServer getServer() {
            return this.server;
        }

        public static class Post
        extends ServerTickEvent {
            public Post(BooleanSupplier haveTime, MinecraftServer server) {
                super(haveTime, server, Phase.END);
            }
        }

        public static class Pre
        extends ServerTickEvent {
            public Pre(BooleanSupplier haveTime, MinecraftServer server) {
                super(haveTime, server, Phase.START);
            }
        }
    }
}

