/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.core;

import java.util.List;
import java.util.function.BiFunction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IModLoadingState;
import net.minecraftforge.fml.IModStateProvider;
import net.minecraftforge.fml.IModStateTransition;
import net.minecraftforge.fml.ModLoadingPhase;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingState;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.core.ParallelTransition;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class ModStateProvider
implements IModStateProvider {
    public static final ModLoadingState ERROR = ModLoadingState.of((String)"ERROR", (ModLoadingPhase)ModLoadingPhase.ERROR).empty();
    public static final ModLoadingState VALIDATE = ModLoadingState.of((String)"VALIDATE", (ModLoadingPhase)ModLoadingPhase.GATHER).empty();
    public static final ModLoadingState CONSTRUCT = ModLoadingState.of((String)"CONSTRUCT", (ModLoadingPhase)ModLoadingPhase.GATHER).after(VALIDATE).message(ml -> "Constructing %d mods".formatted(ml.size())).withTransition((IModStateTransition)new ParallelTransition(ModLoadingStage.CONSTRUCT, FMLConstructModEvent::new));
    public static final ModLoadingState CONFIG_LOAD = ModLoadingState.of((String)"CONFIG_LOAD", (ModLoadingPhase)ModLoadingPhase.LOAD).withInline(ml -> {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get()));
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.COMMON, FMLPaths.CONFIGDIR.get());
    });
    public static final ModLoadingState COMMON_SETUP = ModLoadingState.of((String)"COMMON_SETUP", (ModLoadingPhase)ModLoadingPhase.LOAD).after(CONFIG_LOAD).withTransition((IModStateTransition)new ParallelTransition(ModLoadingStage.COMMON_SETUP, FMLCommonSetupEvent::new));
    public static final ModLoadingState SIDED_SETUP = ModLoadingState.of((String)"SIDED_SETUP", (ModLoadingPhase)ModLoadingPhase.LOAD).after(COMMON_SETUP).withTransition((IModStateTransition)new ParallelTransition(ModLoadingStage.SIDED_SETUP, (BiFunction)DistExecutor.unsafeRunForDist(() -> () -> FMLClientSetupEvent::new, () -> () -> FMLDedicatedServerSetupEvent::new)));
    public static final ModLoadingState ENQUEUE_IMC = ModLoadingState.of((String)"ENQUEUE_IMC", (ModLoadingPhase)ModLoadingPhase.COMPLETE).withTransition((IModStateTransition)new ParallelTransition(ModLoadingStage.ENQUEUE_IMC, InterModEnqueueEvent::new));
    public static final ModLoadingState PROCESS_IMC = ModLoadingState.of((String)"PROCESS_IMC", (ModLoadingPhase)ModLoadingPhase.COMPLETE).after(ENQUEUE_IMC).withTransition((IModStateTransition)new ParallelTransition(ModLoadingStage.PROCESS_IMC, InterModProcessEvent::new));
    public static final ModLoadingState COMPLETE = ModLoadingState.of((String)"COMPLETE", (ModLoadingPhase)ModLoadingPhase.COMPLETE).after(PROCESS_IMC).message(ml -> "completing load of %d mods".formatted(ml.size())).withTransition((IModStateTransition)new ParallelTransition(ModLoadingStage.COMPLETE, FMLLoadCompleteEvent::new));
    public static final ModLoadingState DONE = ModLoadingState.of((String)"DONE", (ModLoadingPhase)ModLoadingPhase.DONE).empty();

    public List<IModLoadingState> getAllStates() {
        return List.of(ERROR, VALIDATE, CONSTRUCT, CONFIG_LOAD, COMMON_SETUP, SIDED_SETUP, ENQUEUE_IMC, PROCESS_IMC, COMPLETE, DONE);
    }
}

