/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public interface INBTBuilder {
    default public Builder nbt() {
        return new Builder();
    }

    public static class Builder
    implements INBTBuilder {
        private final CompoundTag tag = new CompoundTag();

        public CompoundTag build() {
            return this.tag;
        }

        public Builder tag(String key, Tag value) {
            this.tag.put(key, value);
            return this;
        }

        public Builder putByte(String key, byte value) {
            this.tag.putByte(key, value);
            return this;
        }

        public Builder putShort(String key, short value) {
            this.tag.putShort(key, value);
            return this;
        }

        public Builder putInt(String key, int value) {
            this.tag.putInt(key, value);
            return this;
        }

        public Builder putLong(String key, long value) {
            this.tag.putLong(key, value);
            return this;
        }

        public Builder putFloat(String key, float value) {
            this.tag.putFloat(key, value);
            return this;
        }

        public Builder putDouble(String key, double value) {
            this.tag.putDouble(key, value);
            return this;
        }

        public Builder putByteArray(String key, byte ... value) {
            this.tag.putByteArray(key, value);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.21.5")
        public Builder putByteArray(String key, List<Byte> value) {
            byte[] array = new byte[value.size()];
            for (int i = 0; i < value.size(); ++i) {
                array[i] = value.get(i);
            }
            return this.putByteArray(key, array);
        }

        public Builder putIntArray(String key, int ... value) {
            this.tag.putIntArray(key, value);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.21.5")
        public Builder putIntArray(String key, List<Integer> value) {
            int[] array = new int[value.size()];
            for (int i = 0; i < value.size(); ++i) {
                array[i] = value.get(i);
            }
            return this.putIntArray(key, array);
        }

        public Builder putLongArray(String key, long ... value) {
            this.tag.putLongArray(key, value);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.21.5")
        public Builder putLongArray(String key, List<Long> value) {
            long[] array = new long[value.size()];
            for (int i = 0; i < value.size(); ++i) {
                array[i] = value.get(i);
            }
            return this.putLongArray(key, array);
        }

        public Builder put(String key, boolean value) {
            this.tag.putBoolean(key, value);
            return this;
        }

        public Builder put(String key, String value) {
            this.tag.putString(key, value);
            return this;
        }

        public Builder put(String key, UUID value) {
            this.tag.putIntArray(key, UUIDUtil.uuidToIntArray((UUID)value));
            return this;
        }
    }
}

