/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.NotNull;

public abstract sealed class LivingEntityUseItemEvent
extends LivingEvent {
    public static final EventBus<LivingEntityUseItemEvent> BUS = EventBus.create(LivingEntityUseItemEvent.class);
    private final ItemStack item;
    private int duration;

    private LivingEntityUseItemEvent(LivingEntity entity, @NotNull ItemStack item, int duration) {
        super(entity);
        this.item = item;
        this.setDuration(duration);
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public static final class Finish
    extends LivingEntityUseItemEvent {
        public static final EventBus<Finish> BUS = EventBus.create(Finish.class);
        private ItemStack result;

        public Finish(LivingEntity entity, @NotNull ItemStack item, int duration, @NotNull ItemStack result) {
            super(entity, item, duration);
            this.setResultStack(result);
        }

        @NotNull
        public ItemStack getResultStack() {
            return this.result;
        }

        public void setResultStack(@NotNull ItemStack result) {
            this.result = result;
        }
    }

    public static final class Stop
    extends LivingEntityUseItemEvent
    implements Cancellable {
        public static final CancellableEventBus<Stop> BUS = CancellableEventBus.create(Stop.class);

        public Stop(LivingEntity entity, @NotNull ItemStack item, int duration) {
            super(entity, item, duration);
        }
    }

    public static final class Tick
    extends LivingEntityUseItemEvent
    implements Cancellable {
        public static final CancellableEventBus<Tick> BUS = CancellableEventBus.create(Tick.class);

        public Tick(LivingEntity entity, @NotNull ItemStack item, int duration) {
            super(entity, item, duration);
        }
    }

    public static final class Start
    extends LivingEntityUseItemEvent
    implements Cancellable {
        public static final CancellableEventBus<Start> BUS = CancellableEventBus.create(Start.class);

        public Start(LivingEntity entity, @NotNull ItemStack item, int duration) {
            super(entity, item, duration);
        }
    }
}

