/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.EventBus;

public sealed class AdvancementEvent
extends PlayerEvent {
    public static final EventBus<AdvancementEvent> BUS = EventBus.create(AdvancementEvent.class);
    private final AdvancementHolder advancement;

    public AdvancementEvent(Player player, AdvancementHolder advancement) {
        super(player);
        this.advancement = advancement;
    }

    public AdvancementHolder getAdvancement() {
        return this.advancement;
    }

    public static final class AdvancementProgressEvent
    extends AdvancementEvent {
        public static final EventBus<AdvancementProgressEvent> BUS = EventBus.create(AdvancementProgressEvent.class);
        private final AdvancementProgress advancementProgress;
        private final String criterionName;
        private final ProgressType progressType;

        public AdvancementProgressEvent(Player player, AdvancementHolder progressed, AdvancementProgress advancementProgress, String criterionName, ProgressType progressType) {
            super(player, progressed);
            this.advancementProgress = advancementProgress;
            this.criterionName = criterionName;
            this.progressType = progressType;
        }

        public AdvancementProgress getAdvancementProgress() {
            return this.advancementProgress;
        }

        public String getCriterionName() {
            return this.criterionName;
        }

        public ProgressType getProgressType() {
            return this.progressType;
        }

        public static enum ProgressType {
            GRANT,
            REVOKE;

        }
    }

    public static final class AdvancementEarnEvent
    extends AdvancementEvent {
        public static final EventBus<AdvancementEarnEvent> BUS = EventBus.create(AdvancementEarnEvent.class);

        public AdvancementEarnEvent(Player player, AdvancementHolder earned) {
            super(player, earned);
        }
    }
}

