/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gametest;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.gametest.GameTest;
import net.minecraftforge.gametest.GameTestDontPrefix;
import net.minecraftforge.gametest.GameTestNamespace;
import net.minecraftforge.gametest.GameTestPrefix;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ForgeGameTestHooks {
    private static MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    public static boolean isGametestEnabled() {
        return !FMLLoader.isProduction() && (SharedConstants.IS_RUNNING_IN_IDE || ForgeGameTestHooks.isGametestServer() || Boolean.getBoolean("forge.enableGameTest"));
    }

    public static boolean isGametestServer() {
        return !FMLLoader.isProduction() && Boolean.getBoolean("forge.gameTestServer");
    }

    @Nullable
    private static boolean shouldPrefix(Method method) {
        Class<?> cls = method.getDeclaringClass();
        return !method.isAnnotationPresent(GameTestDontPrefix.class) && !cls.isAnnotationPresent(GameTestDontPrefix.class);
    }

    private static String snake(String input) {
        StringBuilder result = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (!result.isEmpty()) {
                    result.append('_');
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static String getPrefix(Class<?> cls) {
        GameTestNamespace holder;
        GameTestPrefix prefix = cls.getAnnotation(GameTestPrefix.class);
        if (prefix != null) {
            return prefix.value() + "/";
        }
        Mod mod = cls.getAnnotation(Mod.class);
        if (mod != null && (holder = cls.getAnnotation(GameTestNamespace.class)) != null && !holder.value().isEmpty()) {
            return mod.value() + "/";
        }
        return cls.getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    private static String getNamespace(Class<?> cls) {
        GameTestNamespace holder = cls.getAnnotation(GameTestNamespace.class);
        if (holder != null && !holder.value().isEmpty()) {
            return holder.value();
        }
        Mod mod = cls.getAnnotation(Mod.class);
        if (mod != null) {
            return mod.value();
        }
        throw new IllegalArgumentException("Could not find modid for " + cls.getName());
    }

    private static ResourceLocation key(String namespace, String prefix, String path) {
        if (path.indexOf(58) != -1) {
            ResourceLocation rl = ResourceLocation.parse((String)path);
            if (!prefix.isEmpty()) {
                return rl.withPrefix(prefix);
            }
            return rl;
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(prefix + path));
    }

    public static Map<ResourceLocation, TestReference> gatherTests(Class<?> root, Object instance) {
        HashMap<ResourceLocation, TestReference> ret = new HashMap<ResourceLocation, TestReference>();
        HashSet<String> seen = new HashSet<String>();
        String class_prefix = ForgeGameTestHooks.getPrefix(root);
        String namespace = ForgeGameTestHooks.getNamespace(root);
        for (Class<?> cls = root; cls != Object.class; cls = cls.getSuperclass()) {
            for (Method method : cls.getDeclaredMethods()) {
                GameTest gametest;
                if (!Modifier.isPublic(method.getModifiers()) || cls != root && Modifier.isStatic(method.getModifiers()) || (gametest = method.getAnnotation(GameTest.class)) == null) continue;
                String owner = method.getDeclaringClass().getName() + "." + method.getName();
                if (method.getParameterCount() != 1 || method.getParameterTypes()[0] != GameTestHelper.class) {
                    throw new IllegalStateException("Invalid @GameTest function " + owner + " incorrect arguments");
                }
                if (!seen.add(method.getName())) continue;
                String prefix = ForgeGameTestHooks.shouldPrefix(method) ? class_prefix : "";
                ResourceLocation name = ForgeGameTestHooks.key(namespace, prefix, gametest.name().isEmpty() ? ForgeGameTestHooks.snake(method.getName()) : gametest.name());
                ResourceLocation structure = "forge:empty3x3x3".equals(gametest.structure()) ? ResourceLocation.parse((String)gametest.structure()) : ForgeGameTestHooks.key(namespace, "", gametest.structure());
                ResourceLocation env = "default".equals(gametest.environment()) ? ResourceLocation.withDefaultNamespace((String)gametest.environment()) : ForgeGameTestHooks.key(namespace, "", gametest.environment());
                TestData data = new TestData((Object)env, structure, gametest.maxTicks(), gametest.setupTicks(), gametest.required(), gametest.rotation(), gametest.manualOnly(), gametest.maxAttempts(), gametest.requiredSuccesses(), gametest.skyAccess());
                MethodHandle handle = ForgeGameTestHooks.unreflect(method, owner);
                Consumer<GameTestHelper> func = Modifier.isStatic(method.getModifiers()) ? ctx -> {
                    try {
                        handle.invoke((GameTestHelper)ctx);
                    }
                    catch (Throwable e) {
                        ForgeGameTestHooks.sneakyThrow(e);
                    }
                } : ctx -> {
                    try {
                        handle.invoke(instance, (GameTestHelper)ctx);
                    }
                    catch (Throwable e) {
                        ForgeGameTestHooks.sneakyThrow(e);
                    }
                };
                ret.put(name, new TestReference(func, (TestData<ResourceLocation>)data));
            }
        }
        return ret;
    }

    private static MethodHandle unreflect(Method method, String owner) {
        try {
            return LOOKUP.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to unreflect " + owner, e);
        }
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public record TestReference(Consumer<GameTestHelper> consumer, TestData<ResourceLocation> data) {
    }
}

