/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;

public final class IdMappingEvent
extends MutableEvent {
    public static final EventBus<IdMappingEvent> BUS = EventBus.create(IdMappingEvent.class);
    private final Map<ResourceLocation, ImmutableList<ModRemapping>> remaps;
    private final ImmutableSet<ResourceLocation> keys;
    private final boolean isFrozen;

    public IdMappingEvent(Map<ResourceLocation, Map<ResourceLocation, IdRemapping>> remaps, boolean isFrozen) {
        this.isFrozen = isFrozen;
        this.remaps = Maps.newHashMap();
        remaps.forEach((name, rm) -> {
            ArrayList<ModRemapping> tmp = new ArrayList<ModRemapping>();
            rm.forEach((key, value) -> tmp.add(new ModRemapping((ResourceLocation)name, (ResourceLocation)key, value.currId, value.newId)));
            tmp.sort(Comparator.comparingInt(o -> o.newId));
            this.remaps.put((ResourceLocation)name, (ImmutableList<ModRemapping>)ImmutableList.copyOf(tmp));
        });
        this.keys = ImmutableSet.copyOf(this.remaps.keySet());
    }

    public ImmutableSet<ResourceLocation> getRegistries() {
        return this.keys;
    }

    public ImmutableList<ModRemapping> getRemaps(ResourceLocation registry) {
        return this.remaps.get(registry);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public static final class ModRemapping {
        public final ResourceLocation registry;
        public final ResourceLocation key;
        public final int oldId;
        public final int newId;

        private ModRemapping(ResourceLocation registry, ResourceLocation key, int oldId, int newId) {
            this.registry = registry;
            this.key = key;
            this.oldId = oldId;
            this.newId = newId;
        }
    }

    public record IdRemapping(int currId, int newId) {
    }
}

