/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import net.minecraftforge.common.chunkio.ChunkIOProvider;
import net.minecraftforge.common.chunkio.QueuedChunk;
import net.minecraftforge.common.util.AsynchronousExecutor;

public class ChunkIOExecutor {
    static final int BASE_THREADS = 1;
    static final int PLAYERS_PER_THREAD = 50;
    private static final AsynchronousExecutor<QueuedChunk, bfh, Runnable, RuntimeException> instance = new AsynchronousExecutor<QueuedChunk, bfh, Runnable, RuntimeException>(new ChunkIOProvider(), 1);

    public static bfh syncChunkLoad(aqu world, bfy loader, qs provider, int x2, int z2) {
        return instance.getSkipQueue(new QueuedChunk(x2, z2, loader, world, provider));
    }

    public static void queueChunkLoad(aqu world, bfy loader, qs provider, int x2, int z2, Runnable runnable) {
        instance.add(new QueuedChunk(x2, z2, loader, world, provider), runnable);
    }

    public static void dropQueuedChunkLoad(aqu world, int x2, int z2, Runnable runnable) {
        instance.drop(new QueuedChunk(x2, z2, null, world, null), runnable);
    }

    public static void adjustPoolSize(int players) {
        int size = Math.max(1, (int)Math.ceil(players / 50));
        instance.setActiveThreads(size);
    }

    public static void tick() {
        instance.finishActive();
    }
}

