/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class FMLEmbeddedChannel
extends EmbeddedChannel {
    public FMLEmbeddedChannel(String channelName, Side source, ChannelHandler ... handlers) {
        this(Loader.instance().activeModContainer(), channelName, source, handlers);
    }

    public FMLEmbeddedChannel(ModContainer container, String channelName, Side source, ChannelHandler ... handlers) {
        super(handlers);
        this.attr(NetworkRegistry.FML_CHANNEL).set((Object)channelName);
        this.attr(NetworkRegistry.CHANNEL_SOURCE).set((Object)source);
        this.attr(NetworkRegistry.MOD_CONTAINER).setIfAbsent((Object)container);
        this.pipeline().addFirst("fml:outbound", (ChannelHandler)new FMLOutboundHandler());
    }

    public id generatePacketFrom(Object object) {
        FMLOutboundHandler.OutboundTarget outboundTarget = (FMLOutboundHandler.OutboundTarget)((Object)this.attr(FMLOutboundHandler.FML_MESSAGETARGET).getAndSet((Object)FMLOutboundHandler.OutboundTarget.NOWHERE));
        this.writeOutbound(new Object[]{object});
        id pkt = (id)this.outboundMessages().poll();
        this.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)outboundTarget);
        return pkt;
    }

    public String findChannelHandlerNameForType(Class<? extends ChannelHandler> type) {
        String targetName = null;
        for (Map.Entry entry : this.pipeline()) {
            if (!type.isInstance(entry.getValue())) continue;
            targetName = (String)entry.getKey();
            break;
        }
        return targetName;
    }
}

