/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelSimpleProperties;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartVariant;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.animation.IAnimatedModel;
import net.minecraftforge.client.model.animation.IClip;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class ModelLoader
extends bot {
    private final Map<bov, IModel> stateModels = Maps.newHashMap();
    private final Set<jy> textures = Sets.newHashSet();
    private final Set<jy> loadingModels = Sets.newHashSet();
    private final Set<bov> missingVariants = Sets.newHashSet();
    private final Map<jy, Exception> loadingExceptions = Maps.newHashMap();
    private IModel missingModel = null;
    private IModel itemModel = new ItemLayerModel(o);
    private boolean isLoading = false;
    private final boolean enableVerboseMissingInfo = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false || Boolean.parseBoolean(System.getProperty("forge.verboseMissingModelLogging", "false"));
    private static final Map<RegistryDelegate<afh>, bgy> customStateMappers = Maps.newHashMap();
    private static final Map<RegistryDelegate<zw>, bfp> customMeshDefinitions = Maps.newHashMap();
    private static final Map<Pair<RegistryDelegate<zw>, Integer>, bov> customModels = Maps.newHashMap();

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(bni manager, bmh map, bgc shapes) {
        super(manager, map, shapes);
        VanillaLoader.instance.setLoader(this);
        ModelLoaderRegistry.clearModelCache();
    }

    public db<bov, boq> a() {
        this.isLoading = true;
        this.loadBlocks();
        this.loadItems();
        try {
            this.missingModel = this.getModel(new jy(a.b(), a.a()));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        this.stateModels.put(a, this.missingModel);
        this.textures.remove(bmh.f);
        this.textures.addAll(b);
        this.j.a(this.f, new bmb(){

            public void a(bmh map) {
                for (jy t : ModelLoader.this.textures) {
                    map.a(t);
                }
            }
        });
        IFlexibleBakedModel missingBaked = this.missingModel.bake(this.missingModel.getDefaultState(), bms.b, DefaultTextureGetter.instance);
        for (Map.Entry<bov, IModel> e : this.stateModels.entrySet()) {
            if (e.getValue() == this.getMissingModel()) {
                this.n.a((Object)e.getKey(), (Object)missingBaked);
                continue;
            }
            this.n.a((Object)e.getKey(), (Object)e.getValue().bake(e.getValue().getDefaultState(), bms.b, DefaultTextureGetter.instance));
        }
        return this.n;
    }

    private void loadBlocks() {
        Map stateMap = this.k.a().a();
        ArrayList variants = Lists.newArrayList(stateMap.values());
        variants.add(new bov("minecraft:item_frame", "normal"));
        variants.add(new bov("minecraft:item_frame", "map"));
        Collections.sort(variants, new Comparator<bov>(){

            @Override
            public int compare(bov v1, bov v2) {
                return v1.toString().compareTo(v2.toString());
            }
        });
        ProgressManager.ProgressBar blockBar = ProgressManager.push("ModelLoader: blocks", variants.size());
        for (bov variant : variants) {
            this.a((Collection)ImmutableList.of((Object)variant));
            blockBar.step(variant.toString());
        }
        ProgressManager.pop(blockBar);
    }

    protected void a(bgm definition, bov location) {
        bgm.d variants = null;
        try {
            variants = definition.b(location.c());
        }
        catch (bgm.b e) {
            this.missingVariants.add(location);
        }
        if (variants != null && !variants.b().isEmpty()) {
            try {
                this.stateModels.put(location, new WeightedRandomModel(location, variants));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void storeException(jy location, Exception exception) {
        this.loadingExceptions.put(location, exception);
    }

    protected bgm a(jy location) {
        try {
            return super.a(location);
        }
        catch (Exception exception) {
            this.storeException(location, new Exception("Could not load model definition for variant " + location, exception));
            return new bgm(new ArrayList());
        }
    }

    private void loadItems() {
        if (FluidRegistry.isUniversalBucketEnabled()) {
            ModelLoader.setBucketModelDefinition(ForgeModContainer.getInstance().universalBucket);
        }
        this.e();
        ArrayList itemVariants = Lists.newArrayList();
        for (zw zw2 : GameData.getItemRegistry().typeSafeIterable()) {
            itemVariants.addAll(this.a(zw2));
        }
        Collections.sort(itemVariants);
        ProgressManager.ProgressBar itemBar = ProgressManager.push("ModelLoader: items", itemVariants.size());
        for (String s : itemVariants) {
            jy file = this.a(s);
            bov memory = ModelLoader.getInventoryVariant(s);
            itemBar.step(memory.toString());
            IModel model = null;
            try {
                model = this.getModel(file);
                if (model == null) {
                    model = this.getMissingModel();
                }
                this.stateModels.put(memory, model);
            }
            catch (FileNotFoundException e) {
                FMLLog.fine("Item json isn't found for '" + memory + "', trying to load the variant from the blockstate json", new Object[0]);
                try {
                    this.a(this.a((jy)memory), memory);
                }
                catch (Exception exception) {
                    this.storeException((jy)memory, new Exception("Could not load item model either from the normal location " + file + " or from the blockstate", exception));
                }
            }
            catch (Exception exception) {
                this.storeException((jy)memory, exception);
            }
        }
        ProgressManager.pop(itemBar);
        if (ForgeModContainer.replaceVanillaBucketModel) {
            bov memory;
            if (!this.stateModels.containsKey(ModelDynBucket.LOCATION)) {
                try {
                    this.a(this.a((jy)ModelDynBucket.LOCATION), ModelDynBucket.LOCATION);
                }
                catch (Exception exception) {
                    FMLLog.getLogger().error("Could not load the forge bucket model from the blockstate", (Throwable)exception);
                    return;
                }
            }
            for (String s : this.a(zy.aw)) {
                memory = ModelLoader.getInventoryVariant(s);
                try {
                    IModel model2 = this.getModel(new jy("forge", "item/bucket"));
                    this.stateModels.put(memory, model2);
                }
                catch (IOException model2) {}
            }
            this.setBucketModel(zy.ax);
            this.setBucketModel(zy.ay);
            if (FluidRegistry.isFluidRegistered("milk")) {
                Fluid fluid = FluidRegistry.getFluid("milk");
                FluidStack milkStack = new FluidStack(fluid, 1000);
                if (FluidContainerRegistry.getContainerCapacity(milkStack, new zx(zy.aw)) == 1000) {
                    this.setBucketModel(zy.aG);
                }
            } else {
                for (String s : this.a(zy.aG)) {
                    memory = ModelLoader.getInventoryVariant(s);
                    try {
                        IModel model = this.getModel(new jy("forge", "item/bucket_milk"));
                        this.stateModels.put(memory, model);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void setBucketModel(zw item) {
        for (String s : this.a(item)) {
            bov memory = ModelLoader.getInventoryVariant(s);
            IModel model = this.stateModels.get(ModelDynBucket.LOCATION);
            if (model == null) continue;
            this.stateModels.put(memory, model);
        }
    }

    public static bov getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new bov(s);
        }
        return new bov(s, "inventory");
    }

    public IModel getModel(jy location) throws IOException {
        if (!ModelLoaderRegistry.loaded(location)) {
            this.loadAnyModel(location);
        }
        return ModelLoaderRegistry.getModel(location);
    }

    protected jy d(jy model) {
        return new jy(model.b(), model.a() + ".json");
    }

    private void loadAnyModel(jy location) throws IOException {
        if (this.loadingModels.contains(location)) {
            throw new IllegalStateException("circular model dependencies involving model " + location);
        }
        this.loadingModels.add(location);
        try {
            IModel model = ModelLoaderRegistry.getModel(location);
            this.resolveDependencies(model);
        }
        finally {
            this.loadingModels.remove(location);
        }
    }

    IModel getVariantModel(bov location) {
        this.a((Collection)ImmutableList.of((Object)location));
        IModel model = this.stateModels.get(location);
        if (model == null) {
            model = this.getMissingModel();
        }
        return model;
    }

    private void resolveDependencies(IModel model) throws IOException {
        for (jy dep : model.getDependencies()) {
            if (dep instanceof bov) {
                this.getVariantModel((bov)dep);
                continue;
            }
            this.getModel(dep);
        }
        this.textures.addAll(model.getTextures());
    }

    public IModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = this.getModel(new jy(a.b(), a.a()));
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return this.missingModel;
    }

    public IModel getItemModel() {
        return this.itemModel;
    }

    public void onPostBakeEvent(db<bov, boq> modelRegistry) {
        boq missingModel = (boq)modelRegistry.a((Object)a);
        HashMap modelErrors = Maps.newHashMap();
        HashMultimap reverseBlockMap = null;
        HashMultimap reverseItemMap = null;
        if (this.enableVerboseMissingInfo) {
            reverseBlockMap = HashMultimap.create();
            for (Map.Entry<Object, Exception> entry : this.k.a().a().entrySet()) {
                reverseBlockMap.put((Object)entry.getValue(), entry.getKey());
            }
            reverseItemMap = HashMultimap.create();
            for (zw zw2 : GameData.getItemRegistry().typeSafeIterable()) {
                for (String s : this.a(zw2)) {
                    bov memory = ModelLoader.getInventoryVariant(s);
                    reverseItemMap.put((Object)memory, (Object)zw2.getRegistryName());
                }
            }
        }
        for (Map.Entry<Object, Exception> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof bov)) continue;
            bov location = (bov)entry.getKey();
            boq model = (boq)modelRegistry.a((Object)location);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = ((jy)entry.getKey()).b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < 5) {
                    String errorMsg = "Exception loading model for variant " + entry.getKey();
                    if (this.enableVerboseMissingInfo) {
                        Collection items;
                        Collection blocks = reverseBlockMap.get((Object)location);
                        if (!blocks.isEmpty()) {
                            errorMsg = blocks.size() == 1 ? errorMsg + " for blockstate \"" + blocks.iterator().next() + "\"" : errorMsg + " for blockstates [\"" + Joiner.on((String)"\", \"").join((Iterable)blocks) + "\"]";
                        }
                        if (!(items = reverseItemMap.get((Object)location)).isEmpty()) {
                            if (!blocks.isEmpty()) {
                                errorMsg = errorMsg + " and";
                            }
                            errorMsg = items.size() == 1 ? errorMsg + " for item \"" + (String)items.iterator().next() + "\"" : errorMsg + " for items [\"" + Joiner.on((String)"\", \"").join((Iterable)items) + "\"]";
                        }
                    }
                    FMLLog.getLogger().error(errorMsg, (Throwable)entry.getValue());
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a((Object)location, (Object)missingModel);
        }
        for (bov bov2 : this.missingVariants) {
            boq model = (boq)modelRegistry.a((Object)bov2);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = bov2.b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < 5) {
                    FMLLog.severe("Model definition for location %s not found", bov2);
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a((Object)bov2, (Object)missingModel);
        }
        for (Map.Entry<Object, Exception> entry : modelErrors.entrySet()) {
            if ((Integer)((Object)entry.getValue()) < 5) continue;
            FMLLog.severe("Suppressed additional %s model loading errors for domain %s", entry.getValue(), entry.getKey());
        }
        this.isLoading = false;
    }

    public static void setCustomStateMapper(afh block, bgy mapper) {
        customStateMappers.put(block.delegate, mapper);
    }

    public static void onRegisterAllBlocks(bgc shapes) {
        for (Map.Entry<RegistryDelegate<afh>, bgy> e : customStateMappers.entrySet()) {
            shapes.a(e.getKey().get(), e.getValue());
        }
    }

    public static void setCustomModelResourceLocation(zw item, int metadata, bov model) {
        customModels.put((Pair<RegistryDelegate<zw>, Integer>)Pair.of((Object)item.delegate, (Object)metadata), model);
        bot.registerItemVariants((zw)item, (jy[])new bov[]{model});
    }

    public static void setCustomMeshDefinition(zw item, bfp meshDefinition) {
        customMeshDefinitions.put(item.delegate, meshDefinition);
    }

    public static void setBucketModelDefinition(zw item) {
        ModelLoader.setCustomMeshDefinition(item, new bfp(){

            public bov a(zx stack) {
                return ModelDynBucket.LOCATION;
            }
        });
        bot.registerItemVariants((zw)item, (jy[])new bov[]{ModelDynBucket.LOCATION});
    }

    public static void onRegisterItems(bfo mesher) {
        for (Map.Entry<RegistryDelegate<zw>, bfp> entry : customMeshDefinitions.entrySet()) {
            mesher.a(entry.getKey().get(), entry.getValue());
        }
        for (Map.Entry<RegistryDelegate<zw>, bfp> entry : customModels.entrySet()) {
            mesher.a((zw)((RegistryDelegate)((Pair)entry.getKey()).getLeft()).get(), ((Integer)((Pair)entry.getKey()).getRight()).intValue(), (bov)entry.getValue());
        }
    }

    public static Function<jy, bmi> defaultTextureGetter() {
        return DefaultTextureGetter.instance;
    }

    private static enum DefaultTextureGetter implements Function<jy, bmi>
    {
        instance;


        public bmi apply(jy location) {
            return ave.A().T().a(location.toString());
        }
    }

    public static class White
    extends bmi {
        public static jy loc = new jy("white");
        public static White instance = new White();

        protected White() {
            super(loc.toString());
        }

        public boolean hasCustomLoader(bni manager, jy location) {
            return true;
        }

        public boolean load(bni manager, jy location) {
            BufferedImage image = new BufferedImage(16, 16, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, 16, 16);
            BufferedImage[] images = new BufferedImage[ave.A().t.J + 1];
            images[0] = image;
            try {
                this.a(images, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        public void register(bmh map) {
            map.setTextureEntry(loc.toString(), (bmi)instance);
        }
    }

    static enum VanillaLoader implements ICustomModelLoader
    {
        instance;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        ModelLoader getLoader() {
            return this.loader;
        }

        public void a(bni resourceManager) {
        }

        @Override
        public boolean accepts(jy modelLocation) {
            return true;
        }

        @Override
        public IModel loadModel(jy modelLocation) throws IOException {
            String modelPath = modelLocation.a();
            if (modelLocation.a().startsWith("models/")) {
                modelPath = modelPath.substring("models/".length());
            }
            jy armatureLocation = new jy(modelLocation.b(), "armatures/" + modelPath + ".json");
            ModelBlockAnimation animation = Animation.INSTANCE.loadVanillaAnimation(armatureLocation);
            ModelLoader modelLoader = this.loader;
            ((Object)((Object)modelLoader)).getClass();
            return modelLoader.new VanillaModelWrapper(modelLocation, this.loader.c(modelLocation), animation);
        }
    }

    private static class FlexibleWeightedBakedModel
    extends box
    implements IFlexibleBakedModel {
        private final bmu format;

        public FlexibleWeightedBakedModel(box parent, bmu format) {
            super(parent.b);
            this.format = format;
        }

        @Override
        public bmu getFormat() {
            return this.format;
        }
    }

    private class WeightedRandomModel
    implements IModel {
        private final List<bgm.c> variants;
        private final List<jy> locations = new ArrayList<jy>();
        private final List<IModel> models = new ArrayList<IModel>();
        private final IModelState defaultState;

        public WeightedRandomModel(bov parent, bgm.d variants) {
            this.variants = variants.b();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (bgm.c v : variants.b()) {
                jy loc = v.a();
                this.locations.add(loc);
                IModel model = null;
                try {
                    model = ModelLoader.this.getModel(loc);
                }
                catch (Exception e) {
                    FMLLog.warning("Unable to load block model: '" + loc + "' for variant: '" + parent + "': " + e.toString(), new Object[0]);
                    model = ModelLoader.this.getMissingModel();
                }
                if (v instanceof ISmartVariant) {
                    model = ((ISmartVariant)v).process(model, ModelLoader.this);
                    try {
                        ModelLoader.this.resolveDependencies(model);
                    }
                    catch (IOException e) {
                        FMLLog.getLogger().error("Exception resolving indirect dependencies for model" + loc, (Throwable)e);
                    }
                    ModelLoader.this.textures.addAll(model.getTextures());
                }
                this.models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)v.getState()));
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoader.this.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        @Override
        public Collection<jy> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        @Override
        public Collection<jy> getTextures() {
            return Collections.emptyList();
        }

        private IModelState addUV(boolean uv, IModelState state) {
            if (uv) {
                return new UVLock(state);
            }
            return state;
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                bgm.c v = this.variants.get(0);
                IModel model = this.models.get(0);
                return model.bake(this.addUV(v.c(), MultiModelState.getPartState(state, model, 0)), format, bakedTextureGetter);
            }
            box.a builder = new box.a();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel model = this.models.get(i);
                bgm.c v = this.variants.get(i);
                builder.a((boq)model.bake(this.addUV(v.c(), MultiModelState.getPartState(state, model, i)), format, bakedTextureGetter), this.variants.get(i).d());
            }
            return new FlexibleWeightedBakedModel(builder.a(), Attributes.DEFAULT_BAKED_FORMAT);
        }

        @Override
        public IModelState getDefaultState() {
            return this.defaultState;
        }
    }

    @Deprecated
    public static class UVLock
    implements IModelState {
        private final IModelState parent;

        public UVLock(IModelState parent) {
            this.parent = parent;
        }

        public IModelState getParent() {
            return this.parent;
        }

        @Override
        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            return this.parent.apply(part);
        }
    }

    private class VanillaModelWrapper
    implements IRetexturableModel<VanillaModelWrapper>,
    IModelSimpleProperties<VanillaModelWrapper>,
    IAnimatedModel {
        private final jy location;
        private final bgl model;
        private final ModelBlockAnimation animation;

        public VanillaModelWrapper(jy location, bgl model, ModelBlockAnimation animation) {
            this.location = location;
            this.model = model;
            this.animation = animation;
        }

        @Override
        public Collection<jy> getDependencies() {
            if (this.model.e() == null || this.model.e().a().startsWith("builtin/")) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.model.e());
        }

        @Override
        public Collection<jy> getTextures() {
            if (this.model.e() != null) {
                if (this.model.e().a().equals("builtin/generated")) {
                    this.model.d = o;
                } else {
                    try {
                        IModel parent = ModelLoader.this.getModel(this.model.e());
                        if (!(parent instanceof VanillaModelWrapper)) {
                            throw new IllegalStateException("vanilla model '" + this.model + "' can't have non-vanilla parent");
                        }
                        this.model.d = ((VanillaModelWrapper)parent).model;
                    }
                    catch (IOException e) {
                        FMLLog.warning("Could not load vanilla model parent '" + this.model.e() + "' for '" + this.model + "': " + e.toString(), new Object[0]);
                        IModel missing = ModelLoader.this.getMissingModel();
                        if (missing instanceof VanillaModelWrapper) {
                            this.model.d = ((VanillaModelWrapper)missing).model;
                        }
                        throw new IllegalStateException("vanilla model '" + this.model + "' has missing parent, and missing model is not a vanilla model");
                    }
                }
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ModelLoader.this.b(this.model)) {
                for (String s : bgp.a) {
                    String r = this.model.c(s);
                    jy loc = new jy(r);
                    if (!r.equals(s)) {
                        builder.add((Object)loc);
                    }
                    if (this.model.f() == p && !loc.equals((Object)bmh.f)) {
                        bmi.b((String)loc.toString());
                        continue;
                    }
                    if (this.model.f() != q || loc.equals((Object)bmh.f)) continue;
                    bmi.a((String)loc.toString());
                }
            }
            for (String s : this.model.c.values()) {
                if (s.startsWith("#")) continue;
                builder.add((Object)new jy(s));
            }
            return builder.build();
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            bgl model = this.model;
            if (model == null) {
                return ModelLoader.this.getMissingModel().bake(ModelLoader.this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
            }
            ArrayList newTransforms = Lists.newArrayList();
            for (int i = 0; i < model.a().size(); ++i) {
                bgh part = (bgh)model.a().get(i);
                newTransforms.add(this.animation.getPartTransform(state, part, i));
            }
            bgr transforms = model.g();
            boolean uvlock = false;
            if (state instanceof UVLock) {
                uvlock = true;
                state = ((UVLock)state).getParent();
            }
            HashMap tMap = Maps.newHashMap();
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(transforms));
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(state));
            SimpleModelState perState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf((Map)tMap));
            if (ModelLoader.this.b(model)) {
                return new ItemLayerModel(model).bake(perState, format, bakedTextureGetter);
            }
            if (ModelLoader.this.c(model)) {
                return new IFlexibleBakedModel.Wrapper((boq)new bos(transforms), format);
            }
            return this.bakeNormal(model, perState, (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity()), newTransforms, format, bakedTextureGetter, uvlock);
        }

        private IFlexibleBakedModel bakeNormal(bgl model, IModelState perState, final TRSRTransformation modelState, List<TRSRTransformation> newTransforms, bmu format, final Function<jy, bmi> bakedTextureGetter, boolean uvLocked) {
            bmi particle = (bmi)bakedTextureGetter.apply((Object)new jy(model.c("particle")));
            bow.a builder = new bow.a(model).a(particle);
            for (int i = 0; i < model.a().size(); ++i) {
                bgh part = (bgh)model.a().get(i);
                TRSRTransformation transformation = modelState;
                if (newTransforms.get(i) != null) {
                    transformation = transformation.compose(newTransforms.get(i));
                    bgj rot = part.d;
                    if (rot == null) {
                        rot = new bgj(new Vector3f(), cq.a.b, 0.0f, false);
                    }
                    part = new bgh(part.a, part.b, part.c, rot, part.e);
                }
                for (Map.Entry e : part.c.entrySet()) {
                    bmi textureatlassprite1 = (bmi)bakedTextureGetter.apply((Object)new jy(model.c(((bgi)e.getValue()).d)));
                    if (((bgi)e.getValue()).b == null || !TRSRTransformation.isInteger(transformation.getMatrix())) {
                        builder.a(ModelLoader.this.makeBakedQuad(part, (bgi)e.getValue(), textureatlassprite1, (cq)e.getKey(), transformation, uvLocked));
                        continue;
                    }
                    builder.a(modelState.rotate(((bgi)e.getValue()).b), ModelLoader.this.makeBakedQuad(part, (bgi)e.getValue(), textureatlassprite1, (cq)e.getKey(), transformation, uvLocked));
                }
            }
            return new ISmartBlockModel.PerspectiveWrapper(new IPerspectiveAwareModel.MapWrapper((IFlexibleBakedModel)new IFlexibleBakedModel.Wrapper(builder.b(), format), perState)){

                @Override
                public boq handleBlockState(alz state) {
                    return VanillaModelWrapper.this.handleBlockState(this.parent, (Function<jy, bmi>)bakedTextureGetter, modelState, state);
                }
            };
        }

        private boq handleBlockState(IFlexibleBakedModel model, Function<jy, bmi> bakedTextureGetter, TRSRTransformation modelState, alz state) {
            IModelState newState;
            IExtendedBlockState exState;
            if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty) && (newState = exState.getValue(Properties.AnimationProperty)) != null) {
                return this.bake(new ModelStateComposition(modelState, newState), model.getFormat(), bakedTextureGetter);
            }
            return model;
        }

        @Override
        public IModel retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ArrayList elements = Lists.newArrayList();
            for (bgh part : this.model.a()) {
                elements.add(new bgh(part.a, part.b, (Map)Maps.newHashMap((Map)part.c), part.d, part.e));
            }
            bgl newModel = new bgl(this.model.e(), (List)elements, (Map)Maps.newHashMap((Map)this.model.c), this.model.b(), this.model.c(), this.model.g());
            newModel.b = this.model.b;
            newModel.d = this.model.d;
            HashSet removed = Sets.newHashSet();
            for (Map.Entry e : textures.entrySet()) {
                if ("".equals(e.getValue())) {
                    removed.add(e.getKey());
                    newModel.c.remove(e.getKey());
                    continue;
                }
                newModel.c.put(e.getKey(), e.getValue());
            }
            HashMap remapped = Maps.newHashMap();
            for (Map.Entry e : newModel.c.entrySet()) {
                String key;
                if (!((String)e.getValue()).startsWith("#") || !newModel.c.containsKey(key = ((String)e.getValue()).substring(1))) continue;
                remapped.put(e.getKey(), newModel.c.get(key));
            }
            newModel.c.putAll(remapped);
            for (bgh part : newModel.a()) {
                Iterator itr = part.c.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    if (!removed.contains(((bgi)entry.getValue()).d)) continue;
                    itr.remove();
                }
            }
            return new VanillaModelWrapper(this.location, newModel, this.animation);
        }

        @Override
        public Optional<? extends IClip> getClip(String name) {
            if (this.animation.getClips().containsKey((Object)name)) {
                return Optional.fromNullable((Object)this.animation.getClips().get((Object)name));
            }
            return Optional.absent();
        }

        @Override
        public IModelState getDefaultState() {
            return bor.a;
        }

        @Override
        public VanillaModelWrapper smoothLighting(boolean value) {
            if (this.model.i == value) {
                return this;
            }
            bgl newModel = new bgl(this.model.e(), this.model.a(), this.model.c, value, this.model.c(), this.model.g());
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.animation);
        }

        @Override
        public VanillaModelWrapper gui3d(boolean value) {
            if (this.model.c() == value) {
                return this;
            }
            bgl newModel = new bgl(this.model.e(), this.model.a(), this.model.c, this.model.i, value, this.model.g());
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.animation);
        }
    }
}

