/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ITransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class TRSRTransformation
implements IModelState,
ITransformation {
    private final javax.vecmath.Matrix4f matrix;
    private boolean full;
    private javax.vecmath.Vector3f translation;
    private Quat4f leftRot;
    private javax.vecmath.Vector3f scale;
    private Quat4f rightRot;
    private static final TRSRTransformation identity;
    private static final float eps = 1.0E-6f;
    private static final float g;
    private static final float cs;
    private static final float ss;
    private static final float sq2;

    public TRSRTransformation(javax.vecmath.Matrix4f matrix) {
        this.matrix = matrix == null ? TRSRTransformation.identity.matrix : matrix;
    }

    public TRSRTransformation(javax.vecmath.Vector3f translation, Quat4f leftRot, javax.vecmath.Vector3f scale, Quat4f rightRot) {
        this.matrix = TRSRTransformation.mul(translation, leftRot, scale, rightRot);
        this.translation = translation != null ? translation : new javax.vecmath.Vector3f();
        this.leftRot = leftRot != null ? leftRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.scale = scale != null ? scale : new javax.vecmath.Vector3f(1.0f, 1.0f, 1.0f);
        this.rightRot = rightRot != null ? rightRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.full = true;
    }

    public TRSRTransformation(bgq transform) {
        this(TRSRTransformation.getMatrix(transform));
    }

    public static javax.vecmath.Matrix4f getMatrix(bgq transform) {
        TRSRTransformation ret = new TRSRTransformation(TRSRTransformation.toVecmath(transform.c), TRSRTransformation.quatFromYXZDegrees(TRSRTransformation.toVecmath(transform.b)), TRSRTransformation.toVecmath(transform.d), null);
        return TRSRTransformation.blockCenterToCorner(ret).getMatrix();
    }

    public TRSRTransformation(bor rotation) {
        this(rotation.getMatrix());
    }

    public TRSRTransformation(cq facing) {
        this(TRSRTransformation.getMatrix(facing));
    }

    public static javax.vecmath.Matrix4f getMatrix(cq facing) {
        switch (facing) {
            case a: {
                return bor.e.getMatrix();
            }
            case b: {
                return bor.m.getMatrix();
            }
            case c: {
                return TRSRTransformation.identity.matrix;
            }
            case d: {
                return bor.c.getMatrix();
            }
            case e: {
                return bor.d.getMatrix();
            }
            case f: {
                return bor.b.getMatrix();
            }
        }
        return new javax.vecmath.Matrix4f();
    }

    public static TRSRTransformation identity() {
        return identity;
    }

    public TRSRTransformation compose(TRSRTransformation b2) {
        javax.vecmath.Matrix4f m2 = this.getMatrix();
        m2.mul(b2.getMatrix());
        return new TRSRTransformation(m2);
    }

    private void genCheck() {
        if (!this.full) {
            Pair<Matrix3f, javax.vecmath.Vector3f> pair = TRSRTransformation.toAffine(this.matrix);
            Triple<Quat4f, javax.vecmath.Vector3f, Quat4f> triple = TRSRTransformation.svdDecompose((Matrix3f)pair.getLeft());
            this.translation = (javax.vecmath.Vector3f)pair.getRight();
            this.leftRot = (Quat4f)triple.getLeft();
            this.scale = (javax.vecmath.Vector3f)triple.getMiddle();
            this.rightRot = (Quat4f)triple.getRight();
            this.full = true;
        }
    }

    public static Quat4f quatFromYXZDegrees(javax.vecmath.Vector3f yxz) {
        return TRSRTransformation.quatFromYXZ((float)Math.toRadians(yxz.y), (float)Math.toRadians(yxz.x), (float)Math.toRadians(yxz.z));
    }

    public static Quat4f quatFromYXZ(javax.vecmath.Vector3f yxz) {
        return TRSRTransformation.quatFromYXZ(yxz.y, yxz.x, yxz.z);
    }

    public static Quat4f quatFromYXZ(float y, float x, float z) {
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f t = new Quat4f();
        t.set(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f));
        ret.mul(t);
        t.set((float)Math.sin(x / 2.0f), 0.0f, 0.0f, (float)Math.cos(x / 2.0f));
        ret.mul(t);
        t.set(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f));
        ret.mul(t);
        return ret;
    }

    public static javax.vecmath.Vector3f toYXZDegrees(Quat4f q) {
        javax.vecmath.Vector3f yxz = TRSRTransformation.toYXZ(q);
        return new javax.vecmath.Vector3f((float)Math.toDegrees(yxz.x), (float)Math.toDegrees(yxz.y), (float)Math.toDegrees(yxz.z));
    }

    public static javax.vecmath.Vector3f toYXZ(Quat4f q) {
        float w2 = q.w * q.w;
        float x2 = q.x * q.x;
        float y2 = q.y * q.y;
        float z2 = q.z * q.z;
        float l = w2 + x2 + y2 + z2;
        float sx = 2.0f * q.w * q.x - 2.0f * q.y * q.z;
        float x = (float)Math.asin(sx / l);
        if (Math.abs(sx) > 0.999f * l) {
            return new javax.vecmath.Vector3f(x, 2.0f * (float)Math.atan2(q.y, q.w), 0.0f);
        }
        return new javax.vecmath.Vector3f(x, (float)Math.atan2(2.0f * q.x * q.z + 2.0f * q.y * q.w, w2 - x2 - y2 + z2), (float)Math.atan2(2.0f * q.x * q.y + 2.0f * q.w * q.z, w2 - x2 + y2 - z2));
    }

    public static javax.vecmath.Matrix4f mul(javax.vecmath.Vector3f translation, Quat4f leftRot, javax.vecmath.Vector3f scale, Quat4f rightRot) {
        javax.vecmath.Matrix4f res = new javax.vecmath.Matrix4f();
        javax.vecmath.Matrix4f t = new javax.vecmath.Matrix4f();
        res.setIdentity();
        if (leftRot != null) {
            t.set(leftRot);
            res.mul(t);
        }
        if (scale != null) {
            t.setIdentity();
            t.m00 = scale.x;
            t.m11 = scale.y;
            t.m22 = scale.z;
            res.mul(t);
        }
        if (rightRot != null) {
            t.set(rightRot);
            res.mul(t);
        }
        if (translation != null) {
            res.setTranslation(translation);
        }
        return res;
    }

    public static Triple<Quat4f, javax.vecmath.Vector3f, Quat4f> svdDecompose(Matrix3f m2) {
        Quat4f u = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f v = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f qt = new Quat4f();
        Matrix3f b2 = new Matrix3f(m2);
        Matrix3f t = new Matrix3f();
        t.transpose(m2);
        b2.mul(t, b2);
        for (int i = 0; i < 5; ++i) {
            v.mul(TRSRTransformation.stepJacobi(b2));
        }
        v.normalize();
        t.set(v);
        b2.set(m2);
        b2.mul(t);
        float ul = 1.0f;
        Pair<Float, Float> p2 = TRSRTransformation.qrGivensQuat(b2.m00, b2.m10);
        qt.set(0.0f, 0.0f, ((Float)p2.getLeft()).floatValue(), ((Float)p2.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m11 = t.m00 = qt.w * qt.w - qt.z * qt.z;
        t.m10 = -2.0f * qt.z * qt.w;
        t.m01 = -t.m10;
        t.m22 = qt.w * qt.w + qt.z * qt.z;
        ul *= t.m22;
        b2.mul(t, b2);
        p2 = TRSRTransformation.qrGivensQuat(b2.m00, b2.m20);
        qt.set(0.0f, -((Float)p2.getLeft()).floatValue(), 0.0f, ((Float)p2.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m22 = t.m00 = qt.w * qt.w - qt.y * qt.y;
        t.m20 = 2.0f * qt.y * qt.w;
        t.m02 = -t.m20;
        t.m11 = qt.w * qt.w + qt.y * qt.y;
        ul *= t.m11;
        b2.mul(t, b2);
        p2 = TRSRTransformation.qrGivensQuat(b2.m11, b2.m21);
        qt.set(((Float)p2.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p2.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m22 = t.m11 = qt.w * qt.w - qt.x * qt.x;
        t.m21 = -2.0f * qt.x * qt.w;
        t.m12 = -t.m21;
        t.m00 = qt.w * qt.w + qt.x * qt.x;
        ul *= t.m00;
        b2.mul(t, b2);
        ul = 1.0f / ul;
        u.scale((float)Math.sqrt(ul));
        javax.vecmath.Vector3f s = new javax.vecmath.Vector3f(b2.m00 * ul, b2.m11 * ul, b2.m22 * ul);
        return Triple.of((Object)u, (Object)s, (Object)v);
    }

    private static float rsqrt(float f) {
        float f2 = 0.5f * f;
        int i = Float.floatToIntBits(f);
        i = 1597463007 - (i >> 1);
        f = Float.intBitsToFloat(i);
        f *= 1.5f - f2 * f * f;
        return f;
    }

    private static Pair<Float, Float> approxGivensQuat(float a11, float a12, float a22) {
        float sh = a12;
        float ch = 2.0f * (a11 - a22);
        boolean b2 = g * sh * sh < ch * ch;
        float w = TRSRTransformation.rsqrt(sh * sh + ch * ch);
        ch = b2 ? w * ch : cs;
        sh = b2 ? w * sh : ss;
        return Pair.of((Object)Float.valueOf(sh), (Object)Float.valueOf(ch));
    }

    private static final void swapNeg(Matrix3f m2, int i, int j2) {
        float[] t = new float[3];
        m2.getColumn(j2, t);
        for (int k2 = 0; k2 < 3; ++k2) {
            m2.setElement(k2, j2, -m2.getElement(k2, i));
        }
        m2.setColumn(i, t);
    }

    private static void sortSingularValues(Matrix3f b2, Quat4f v) {
        float f;
        float p0 = b2.m00 * b2.m00 + b2.m10 * b2.m10 + b2.m20 * b2.m20;
        float p1 = b2.m01 * b2.m01 + b2.m11 * b2.m11 + b2.m21 * b2.m21;
        float p2 = b2.m02 * b2.m02 + b2.m12 * b2.m12 + b2.m22 * b2.m22;
        Quat4f t = new Quat4f();
        if (p0 < p1) {
            TRSRTransformation.swapNeg(b2, 0, 1);
            t.set(0.0f, 0.0f, sq2, sq2);
            v.mul(t);
            f = p0;
            p0 = p1;
            p1 = f;
        }
        if (p0 < p2) {
            TRSRTransformation.swapNeg(b2, 0, 2);
            t.set(0.0f, sq2, 0.0f, sq2);
            v.mul(t);
            f = p0;
            p0 = p2;
            p2 = f;
        }
        if (p1 < p2) {
            TRSRTransformation.swapNeg(b2, 1, 2);
            t.set(sq2, 0.0f, 0.0f, sq2);
            v.mul(t);
        }
    }

    private static Pair<Float, Float> qrGivensQuat(float a1, float a2) {
        float p2 = (float)Math.sqrt(a1 * a1 + a2 * a2);
        float sh = p2 > 1.0E-6f ? a2 : 0.0f;
        float ch = Math.abs(a1) + Math.max(p2, 1.0E-6f);
        if (a1 < 0.0f) {
            float f = sh;
            sh = ch;
            ch = f;
        }
        float w = TRSRTransformation.rsqrt(ch * ch + sh * sh);
        return Pair.of((Object)Float.valueOf(sh *= w), (Object)Float.valueOf(ch *= w));
    }

    private static Quat4f stepJacobi(Matrix3f m2) {
        Pair<Float, Float> p2;
        Matrix3f t = new Matrix3f();
        Quat4f qt = new Quat4f();
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        if (m2.m01 * m2.m01 + m2.m10 * m2.m10 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m2.m00, 0.5f * (m2.m01 + m2.m10), m2.m11);
            qt.set(0.0f, 0.0f, ((Float)p2.getLeft()).floatValue(), ((Float)p2.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m11 = t.m00 = qt.w * qt.w - qt.z * qt.z;
            t.m10 = 2.0f * qt.z * qt.w;
            t.m01 = -t.m10;
            t.m22 = qt.w * qt.w + qt.z * qt.z;
            m2.mul(m2, t);
            t.transpose();
            m2.mul(t, m2);
        }
        if (m2.m02 * m2.m02 + m2.m20 * m2.m20 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m2.m00, 0.5f * (m2.m02 + m2.m20), m2.m22);
            qt.set(0.0f, -((Float)p2.getLeft()).floatValue(), 0.0f, ((Float)p2.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m22 = t.m00 = qt.w * qt.w - qt.y * qt.y;
            t.m20 = -2.0f * qt.y * qt.w;
            t.m02 = -t.m20;
            t.m11 = qt.w * qt.w + qt.y * qt.y;
            m2.mul(m2, t);
            t.transpose();
            m2.mul(t, m2);
        }
        if (m2.m12 * m2.m12 + m2.m21 * m2.m21 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m2.m11, 0.5f * (m2.m12 + m2.m21), m2.m22);
            qt.set(((Float)p2.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p2.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m22 = t.m11 = qt.w * qt.w - qt.x * qt.x;
            t.m21 = 2.0f * qt.x * qt.w;
            t.m12 = -t.m21;
            t.m00 = qt.w * qt.w + qt.x * qt.x;
            m2.mul(m2, t);
            t.transpose();
            m2.mul(t, m2);
        }
        return ret;
    }

    public static Pair<Matrix3f, javax.vecmath.Vector3f> toAffine(javax.vecmath.Matrix4f m2) {
        m2.mul(1.0f / m2.m33);
        javax.vecmath.Vector3f trans = new javax.vecmath.Vector3f(m2.m03, m2.m13, m2.m23);
        Matrix3f linear = new Matrix3f(m2.m00, m2.m01, m2.m02, m2.m10, m2.m11, m2.m12, m2.m20, m2.m21, m2.m22);
        return Pair.of((Object)linear, (Object)trans);
    }

    public bgq toItemTransform() {
        return new bgq(TRSRTransformation.toLwjgl(TRSRTransformation.toYXZDegrees(this.getLeftRot())), TRSRTransformation.toLwjgl(this.getTranslation()), TRSRTransformation.toLwjgl(this.getScale()));
    }

    @Override
    public javax.vecmath.Matrix4f getMatrix() {
        return (javax.vecmath.Matrix4f)this.matrix.clone();
    }

    public javax.vecmath.Vector3f getTranslation() {
        this.genCheck();
        return (javax.vecmath.Vector3f)this.translation.clone();
    }

    public Quat4f getLeftRot() {
        this.genCheck();
        return (Quat4f)this.leftRot.clone();
    }

    public javax.vecmath.Vector3f getScale() {
        this.genCheck();
        return (javax.vecmath.Vector3f)this.scale.clone();
    }

    public Quat4f getRightRot() {
        this.genCheck();
        return (Quat4f)this.rightRot.clone();
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)this);
    }

    @Override
    public cq rotate(cq facing) {
        return TRSRTransformation.rotate(this.matrix, facing);
    }

    public static cq rotate(javax.vecmath.Matrix4f matrix, cq facing) {
        df dir = facing.m();
        Vector4f vec = new Vector4f((float)dir.n(), (float)dir.o(), (float)dir.p(), 0.0f);
        matrix.transform((Tuple4f)vec);
        return cq.a((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static boolean isInteger(javax.vecmath.Matrix4f matrix) {
        javax.vecmath.Matrix4f m2 = new javax.vecmath.Matrix4f();
        m2.setIdentity();
        m2.m32 = 1.0f;
        m2.m31 = 1.0f;
        m2.m30 = 1.0f;
        m2.m33 = 0.0f;
        m2.mul(matrix, m2);
        for (int i = 0; i < 3; ++i) {
            for (int j2 = 0; j2 < 3; ++j2) {
                float v = m2.getElement(i, j2) / m2.getElement(3, j2);
                if (!((double)Math.abs(v - (float)Math.round(v)) > 1.0E-5)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int rotate(cq facing, int vertexIndex) {
        return vertexIndex;
    }

    public String toString() {
        this.genCheck();
        return Objects.toStringHelper(this.getClass()).add("matrix", (Object)this.matrix).add("translation", (Object)this.translation).add("leftRot", (Object)this.leftRot).add("scale", (Object)this.scale).add("rightRot", (Object)this.rightRot).toString();
    }

    public static TRSRTransformation blockCenterToCorner(TRSRTransformation transform) {
        javax.vecmath.Matrix4f ret = new javax.vecmath.Matrix4f(transform.getMatrix());
        javax.vecmath.Matrix4f tmp = new javax.vecmath.Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public static TRSRTransformation blockCornerToCenter(TRSRTransformation transform) {
        javax.vecmath.Matrix4f ret = new javax.vecmath.Matrix4f(transform.getMatrix());
        javax.vecmath.Matrix4f tmp = new javax.vecmath.Matrix4f();
        tmp.setIdentity();
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.matrix == null ? 0 : this.matrix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TRSRTransformation other = (TRSRTransformation)obj;
        return !(this.matrix == null ? other.matrix != null : !this.matrix.equals(other.matrix));
    }

    public static javax.vecmath.Vector3f toVecmath(Vector3f vec) {
        return new javax.vecmath.Vector3f(vec.x, vec.y, vec.z);
    }

    public static Vector4f toVecmath(org.lwjgl.util.vector.Vector4f vec) {
        return new Vector4f(vec.x, vec.y, vec.z, vec.w);
    }

    public static javax.vecmath.Matrix4f toVecmath(Matrix4f m2) {
        return new javax.vecmath.Matrix4f(m2.m00, m2.m10, m2.m20, m2.m30, m2.m01, m2.m11, m2.m21, m2.m31, m2.m02, m2.m12, m2.m22, m2.m32, m2.m03, m2.m13, m2.m23, m2.m33);
    }

    public static Vector3f toLwjgl(javax.vecmath.Vector3f vec) {
        return new Vector3f(vec.x, vec.y, vec.z);
    }

    public static org.lwjgl.util.vector.Vector4f toLwjgl(Vector4f vec) {
        return new org.lwjgl.util.vector.Vector4f(vec.x, vec.y, vec.z, vec.w);
    }

    public static Matrix4f toLwjgl(javax.vecmath.Matrix4f m2) {
        Matrix4f r = new Matrix4f();
        r.m00 = m2.m00;
        r.m01 = m2.m10;
        r.m02 = m2.m20;
        r.m03 = m2.m30;
        r.m10 = m2.m01;
        r.m11 = m2.m11;
        r.m12 = m2.m21;
        r.m13 = m2.m31;
        r.m20 = m2.m02;
        r.m21 = m2.m12;
        r.m22 = m2.m22;
        r.m23 = m2.m32;
        r.m30 = m2.m03;
        r.m31 = m2.m13;
        r.m32 = m2.m23;
        r.m33 = m2.m33;
        return r;
    }

    public static javax.vecmath.Vector3f lerp(Tuple3f from, Tuple3f to, float progress) {
        javax.vecmath.Vector3f res = new javax.vecmath.Vector3f(from);
        res.interpolate(from, to, progress);
        return res;
    }

    public static Vector4f lerp(Tuple4f from, Tuple4f to, float progress) {
        Vector4f res = new Vector4f(from);
        res.interpolate(from, to, progress);
        return res;
    }

    public static Quat4f slerp(Quat4f from, Quat4f to, float progress) {
        Quat4f res = new Quat4f();
        res.interpolate(from, to, progress);
        return res;
    }

    public TRSRTransformation slerp(TRSRTransformation that, float progress) {
        return new TRSRTransformation(TRSRTransformation.lerp((Tuple3f)this.getTranslation(), (Tuple3f)that.getTranslation(), progress), TRSRTransformation.slerp(this.getLeftRot(), that.getLeftRot(), progress), TRSRTransformation.lerp((Tuple3f)this.getScale(), (Tuple3f)that.getScale(), progress), TRSRTransformation.slerp(this.getRightRot(), that.getRightRot(), progress));
    }

    static {
        javax.vecmath.Matrix4f m2 = new javax.vecmath.Matrix4f();
        m2.setIdentity();
        identity = new TRSRTransformation(m2);
        identity.getLeftRot();
        g = 3.0f + 2.0f * (float)Math.sqrt(2.0);
        cs = (float)Math.cos(0.39269908169872414);
        ss = (float)Math.sin(0.39269908169872414);
        sq2 = 1.0f / (float)Math.sqrt(2.0);
    }
}

