/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.server.FMLServerHandler;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private IFMLSidedHandler sidedDelegate;
    private boolean noForge;
    private List<String> brandings;
    private List<String> brandingsNoMC;
    private List<ICrashCallable> crashCallables = Lists.newArrayList((Object[])new ICrashCallable[]{Loader.instance().getCallableCrashInformation()});
    private Set<atm> handlerSet = Sets.newSetFromMap((Map)new MapMaker().weakKeys().makeMap());
    private WeakReference<atm> handlerToCheck;
    private EventBus eventBus = MinecraftForge.EVENT_BUS;
    private volatile CountDownLatch exitLatch = null;

    private FMLCommonHandler() {
        this.registerCrashCallable(new ICrashCallable(){

            @Override
            public String call() throws Exception {
                StringBuilder builder = new StringBuilder();
                Joiner joiner = Joiner.on((String)"\n  ");
                for (String coreMod : CoreModManager.getTransformers().keySet()) {
                    builder.append("\n" + coreMod + "\n  ").append(joiner.join((Iterable)CoreModManager.getTransformers().get(coreMod)));
                }
                return builder.toString();
            }

            @Override
            public String getLabel() {
                return "Loaded coremods (and transformers)";
            }
        });
    }

    @Deprecated
    public EventBus bus() {
        return this.eventBus;
    }

    public void beginLoading(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
        MinecraftForge.initialize();
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object mod) {
        if (mod instanceof String) {
            return Loader.instance().getIndexedModList().get(mod);
        }
        return (ModContainer)Loader.instance().getReversedModObjectList().get(mod);
    }

    public Logger getFMLLogger() {
        return FMLLog.getLogger();
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public Side getEffectiveSide() {
        Thread thr = Thread.currentThread();
        if (thr.getName().equals("Server thread") || thr.getName().startsWith("Netty Server IO")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLLog.log(Level.ERROR, exception, "Something raised an exception. The message was '%s'. 'stopGame' is %b", message, stopGame);
        if (stopGame) {
            this.getSidedDelegate().haltGame(message, exception);
        }
    }

    public void computeBranding() {
        if (this.brandings == null) {
            ImmutableList.Builder brd = ImmutableList.builder();
            brd.add((Object)Loader.instance().getMCVersionString());
            brd.add((Object)Loader.instance().getMCPVersionString());
            brd.add((Object)("Powered by Forge " + ForgeVersion.getVersion()));
            if (this.sidedDelegate != null) {
                brd.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
            }
            if (Loader.instance().getFMLBrandingProperties().containsKey("fmlbranding")) {
                brd.add((Object)Loader.instance().getFMLBrandingProperties().get("fmlbranding"));
            }
            int tModCount = Loader.instance().getModList().size();
            int aModCount = Loader.instance().getActiveModList().size();
            brd.add((Object)String.format("%d mod%s loaded, %d mod%s active", tModCount, tModCount != 1 ? "s" : "", aModCount, aModCount != 1 ? "s" : ""));
            this.brandings = brd.build();
            this.brandingsNoMC = this.brandings.subList(1, this.brandings.size());
        }
    }

    public List<String> getBrandings(boolean includeMC) {
        if (this.brandings == null) {
            this.computeBranding();
        }
        return includeMC ? ImmutableList.copyOf(this.brandings) : ImmutableList.copyOf(this.brandingsNoMC);
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void onPostServerTick() {
        this.bus().post(new TickEvent.ServerTickEvent(TickEvent.Phase.END));
    }

    public void onPostWorldTick(adm world) {
        this.bus().post(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.END, world));
    }

    public void onPreServerTick() {
        this.bus().post(new TickEvent.ServerTickEvent(TickEvent.Phase.START));
    }

    public void onPreWorldTick(adm world) {
        this.bus().post(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.START, world));
    }

    public boolean handleServerAboutToStart(MinecraftServer server) {
        return Loader.instance().serverAboutToStart(server);
    }

    public boolean handleServerStarting(MinecraftServer server) {
        return Loader.instance().serverStarting(server);
    }

    public void handleServerStarted() {
        Loader.instance().serverStarted();
        this.sidedDelegate.allowLogins();
    }

    public void handleServerStopping() {
        Loader.instance().serverStopping();
    }

    public File getSavesDirectory() {
        return this.sidedDelegate.getSavesDirectory();
    }

    public MinecraftServer getMinecraftServerInstance() {
        return this.sidedDelegate.getServer();
    }

    public void showGuiScreen(Object clientGuiElement) {
        this.sidedDelegate.showGuiScreen(clientGuiElement);
    }

    public void queryUser(StartupQuery query) throws InterruptedException {
        this.sidedDelegate.queryUser(query);
    }

    public void onServerStart(MinecraftServer dedicatedServer) {
        FMLServerHandler.instance();
        this.sidedDelegate.beginServerLoading(dedicatedServer);
    }

    public void onServerStarted() {
        this.sidedDelegate.finishServerLoading();
    }

    public void onPreClientTick() {
        this.bus().post(new TickEvent.ClientTickEvent(TickEvent.Phase.START));
    }

    public void onPostClientTick() {
        this.bus().post(new TickEvent.ClientTickEvent(TickEvent.Phase.END));
    }

    public void onRenderTickStart(float timer) {
        Animation.setClientPartialTickTime(timer);
        this.bus().post(new TickEvent.RenderTickEvent(TickEvent.Phase.START, timer));
    }

    public void onRenderTickEnd(float timer) {
        this.bus().post(new TickEvent.RenderTickEvent(TickEvent.Phase.END, timer));
    }

    public void onPlayerPreTick(wn player) {
        this.bus().post(new TickEvent.PlayerTickEvent(TickEvent.Phase.START, player));
    }

    public void onPlayerPostTick(wn player) {
        this.bus().post(new TickEvent.PlayerTickEvent(TickEvent.Phase.END, player));
    }

    public void registerCrashCallable(ICrashCallable callable) {
        this.crashCallables.add(callable);
    }

    public void enhanceCrashReport(b crashReport, c category) {
        for (ICrashCallable call : this.crashCallables) {
            category.a(call.getLabel(), (Callable)call);
        }
    }

    public void handleWorldDataSave(atm handler, ato worldInfo, dn tagCompound) {
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            dn dataForWriting = wac.getDataForWriting(handler, worldInfo);
            tagCompound.a(mc.getModId(), (eb)dataForWriting);
        }
    }

    public void handleWorldDataLoad(atm handler, ato worldInfo, dn tagCompound) {
        if (this.getEffectiveSide() != Side.SERVER) {
            return;
        }
        if (this.handlerSet.contains(handler)) {
            return;
        }
        this.handlerSet.add(handler);
        this.handlerToCheck = new WeakReference<atm>(handler);
        HashMap additionalProperties = Maps.newHashMap();
        worldInfo.setAdditionalProperties((Map)additionalProperties);
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            wac.readData(handler, worldInfo, additionalProperties, tagCompound.m(mc.getModId()));
        }
    }

    public void confirmBackupLevelDatUse(atm handler) {
        if (this.handlerToCheck == null || this.handlerToCheck.get() != handler) {
            this.handlerToCheck = null;
            return;
        }
        String text = "Forge Mod Loader detected that the backup level.dat is being used.\n\nThis may happen due to a bug or corruption, continuing can damage\nyour world beyond repair or lose data / progress.\n\nIt's recommended to create a world backup before continuing.";
        boolean confirmed = StartupQuery.confirm(text);
        if (!confirmed) {
            StartupQuery.abort();
        }
    }

    public boolean shouldServerBeKilledQuietly() {
        if (this.sidedDelegate == null) {
            return false;
        }
        return this.sidedDelegate.shouldServerShouldBeKilledQuietly();
    }

    public void expectServerStopped() {
        this.exitLatch = new CountDownLatch(1);
    }

    public void handleExit(int retVal) {
        CountDownLatch latch = this.exitLatch;
        if (latch != null) {
            try {
                FMLLog.info("Waiting for the server to terminate/save.", new Object[0]);
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    FMLLog.warning("The server didn't stop within 10 seconds, exiting anyway.", new Object[0]);
                } else {
                    FMLLog.info("Server terminated.", new Object[0]);
                }
            }
            catch (InterruptedException e2) {
                FMLLog.warning("Interrupted wait, exiting.", new Object[0]);
            }
        }
        System.exit(retVal);
    }

    public void handleServerStopped() {
        CountDownLatch latch;
        this.sidedDelegate.serverStopped();
        MinecraftServer server = this.getMinecraftServerInstance();
        Loader.instance().serverStopped();
        if (server != null) {
            ObfuscationReflectionHelper.setPrivateValue(MinecraftServer.class, server, Boolean.valueOf(false), "field_71316_v", "u", "serverStopped");
        }
        if ((latch = this.exitLatch) != null) {
            latch.countDown();
            this.exitLatch = null;
        }
    }

    public String getModName() {
        ArrayList modNames = Lists.newArrayListWithExpectedSize((int)3);
        modNames.add("fml");
        if (!this.noForge) {
            modNames.add("forge");
        }
        if (Loader.instance().getFMLBrandingProperties().containsKey("snooperbranding")) {
            modNames.add(Loader.instance().getFMLBrandingProperties().get("snooperbranding"));
        }
        return Joiner.on((char)',').join((Iterable)modNames);
    }

    public void addModToResourcePack(ModContainer container) {
        this.sidedDelegate.addModAsResource(container);
    }

    public String getCurrentLanguage() {
        return this.sidedDelegate.getCurrentLanguage();
    }

    public void bootstrap() {
    }

    public ek getClientToServerNetworkManager() {
        return this.sidedDelegate.getClientToServerNetworkManager();
    }

    public void fireMouseInput() {
        this.bus().post(new InputEvent.MouseInputEvent());
    }

    public void fireKeyInput() {
        this.bus().post(new InputEvent.KeyInputEvent());
    }

    public void firePlayerChangedDimensionEvent(wn player, int fromDim, int toDim) {
        this.bus().post(new PlayerEvent.PlayerChangedDimensionEvent(player, fromDim, toDim));
    }

    public void firePlayerLoggedIn(wn player) {
        this.bus().post(new PlayerEvent.PlayerLoggedInEvent(player));
    }

    public void firePlayerLoggedOut(wn player) {
        this.bus().post(new PlayerEvent.PlayerLoggedOutEvent(player));
    }

    public void firePlayerRespawnEvent(wn player) {
        this.bus().post(new PlayerEvent.PlayerRespawnEvent(player));
    }

    public void firePlayerItemPickupEvent(wn player, uz item) {
        this.bus().post(new PlayerEvent.ItemPickupEvent(player, item));
    }

    public void firePlayerCraftingEvent(wn player, zx crafted, og craftMatrix) {
        this.bus().post(new PlayerEvent.ItemCraftedEvent(player, crafted, craftMatrix));
    }

    public void firePlayerSmeltedEvent(wn player, zx smelted) {
        this.bus().post(new PlayerEvent.ItemSmeltedEvent(player, smelted));
    }

    public ep getClientPlayHandler() {
        return this.sidedDelegate.getClientPlayHandler();
    }

    public void fireNetRegistrationEvent(ek manager, Set<String> channelSet, String channel, Side side) {
        this.sidedDelegate.fireNetRegistrationEvent(this.bus(), manager, channelSet, channel, side);
    }

    public boolean shouldAllowPlayerLogins() {
        return this.sidedDelegate.shouldAllowPlayerLogins();
    }

    public boolean handleServerHandshake(jc packet, ek manager) {
        if (!this.shouldAllowPlayerLogins()) {
            fa text = new fa("Server is still starting! Please wait before reconnecting.");
            FMLLog.info("Disconnecting Player: " + text.c(), new Object[0]);
            manager.a((ff)new jj((eu)text));
            manager.a((eu)text);
            return false;
        }
        if (packet.a() == el.d && !NetworkRegistry.INSTANCE.isVanillaAccepted(Side.CLIENT) && !packet.hasFMLMarker()) {
            manager.a(el.d);
            fa text = new fa("This server requires FML/Forge to be installed. Contact your server admin for more details.");
            FMLLog.info("Disconnecting Player: " + text.c(), new Object[0]);
            manager.a((ff)new jj((eu)text));
            manager.a((eu)text);
            return false;
        }
        manager.channel().attr(NetworkRegistry.FML_MARKER).set((Object)packet.hasFMLMarker());
        return true;
    }

    public void processWindowMessages() {
        if (this.sidedDelegate == null) {
            return;
        }
        this.sidedDelegate.processWindowMessages();
    }

    public void exitJava(int exitCode, boolean hardExit) {
        FMLLog.log(Level.INFO, "Java has been asked to exit (code %d) by %s.", exitCode, Thread.currentThread().getStackTrace()[1]);
        if (hardExit) {
            FMLLog.log(Level.INFO, "This is an abortive exit and could cause world corruption or other things", new Object[0]);
        }
        if (Boolean.parseBoolean(System.getProperty("fml.debugExit", "false"))) {
            FMLLog.log(Level.INFO, new Throwable(), "Exit trace", new Object[0]);
        } else {
            FMLLog.log(Level.INFO, "If this was an unexpected exit, use -Dfml.debugExit=true as a JVM argument to find out where it was called", new Object[0]);
        }
        if (hardExit) {
            Runtime.getRuntime().halt(exitCode);
        } else {
            Runtime.getRuntime().exit(exitCode);
        }
    }

    public od getWorldThread(ep net) {
        return this.sidedDelegate.getWorldThread(net);
    }

    public static void callFuture(FutureTask<?> task) {
        try {
            task.run();
            task.get();
        }
        catch (InterruptedException e2) {
            FMLLog.log(Level.FATAL, e2, "Exception caught executing FutureTask: " + e2.toString(), new Object[0]);
        }
        catch (ExecutionException e3) {
            FMLLog.log(Level.FATAL, e3, "Exception caught executing FutureTask: " + e3.toString(), new Object[0]);
        }
    }

    public InputStream loadLanguage(Map<String, String> table, InputStream inputstream) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)inputstream);
        boolean isEnhanced = false;
        for (String line : IOUtils.readLines((InputStream)new ByteArrayInputStream(data), (Charset)Charsets.UTF_8)) {
            if (line.isEmpty() || line.charAt(0) != '#' || !(line = line.substring(1).trim()).equals("PARSE_ESCAPES")) continue;
            isEnhanced = true;
            break;
        }
        if (!isEnhanced) {
            return new ByteArrayInputStream(data);
        }
        Properties props = new Properties();
        props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(data), Charsets.UTF_8));
        for (Map.Entry<Object, Object> e2 : props.entrySet()) {
            table.put((String)e2.getKey(), (String)e2.getValue());
        }
        props.clear();
        return null;
    }

    public String stripSpecialChars(String message) {
        return this.sidedDelegate != null ? this.sidedDelegate.stripSpecialChars(message) : message;
    }
}

