/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.jimfs.File;
import com.google.common.jimfs.FileLookup;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class AttributeProvider {
    public abstract String name();

    public ImmutableSet<String> inherits() {
        return ImmutableSet.of();
    }

    public abstract Class<? extends FileAttributeView> viewType();

    public abstract FileAttributeView view(FileLookup var1, ImmutableMap<String, FileAttributeView> var2);

    public ImmutableMap<String, ?> defaultValues(Map<String, ?> userDefaults) {
        return ImmutableMap.of();
    }

    public abstract ImmutableSet<String> fixedAttributes();

    public boolean supports(String attribute) {
        return this.fixedAttributes().contains(attribute);
    }

    public ImmutableSet<String> attributes(File file) {
        return this.fixedAttributes();
    }

    @NullableDecl
    public abstract Object get(File var1, String var2);

    public abstract void set(File var1, String var2, String var3, Object var4, boolean var5);

    @NullableDecl
    public Class<? extends BasicFileAttributes> attributesType() {
        return null;
    }

    public BasicFileAttributes readAttributes(File file) {
        throw new UnsupportedOperationException();
    }

    protected static RuntimeException unsettable(String view, String attribute, boolean create) {
        AttributeProvider.checkNotCreate(view, attribute, create);
        throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(view).length() + String.valueOf(attribute).length()).append("cannot set attribute '").append(view).append(":").append(attribute).append("'").toString());
    }

    protected static void checkNotCreate(String view, String attribute, boolean create) {
        if (create) {
            throw new UnsupportedOperationException(new StringBuilder(45 + String.valueOf(view).length() + String.valueOf(attribute).length()).append("cannot set attribute '").append(view).append(":").append(attribute).append("' during file creation").toString());
        }
    }

    protected static <T> T checkType(String view, String attribute, Object value, Class<T> type) {
        Preconditions.checkNotNull(value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw AttributeProvider.invalidType(view, attribute, value, type);
    }

    protected static IllegalArgumentException invalidType(String view, String attribute, Object value, Class<?> ... expectedTypes) {
        Object object;
        if (expectedTypes.length == 1) {
            object = expectedTypes[0];
        } else {
            String string = String.valueOf(Arrays.toString(expectedTypes));
            object = string.length() != 0 ? "one of ".concat(string) : new String("one of ");
        }
        Class<?> expected = object;
        String string = String.valueOf(value.getClass());
        String string2 = String.valueOf(expected);
        throw new IllegalArgumentException(new StringBuilder(42 + String.valueOf(string).length() + String.valueOf(view).length() + String.valueOf(attribute).length() + String.valueOf(string2).length()).append("invalid type ").append(string).append(" for attribute '").append(view).append(":").append(attribute).append("': expected ").append(string2).toString());
    }
}

