/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.Preconditions;
import com.google.common.jimfs.AbstractWatchService;
import com.google.common.jimfs.FileSystemView;
import com.google.common.jimfs.PathService;
import com.google.common.jimfs.PollingWatchService;
import java.util.concurrent.TimeUnit;

public abstract class WatchServiceConfiguration {
    static final WatchServiceConfiguration DEFAULT = WatchServiceConfiguration.polling(5L, TimeUnit.SECONDS);

    public static WatchServiceConfiguration polling(long interval, TimeUnit timeUnit) {
        return new PollingConfig(interval, timeUnit);
    }

    WatchServiceConfiguration() {
    }

    abstract AbstractWatchService newWatchService(FileSystemView var1, PathService var2);

    private static final class PollingConfig
    extends WatchServiceConfiguration {
        private final long interval;
        private final TimeUnit timeUnit;

        private PollingConfig(long interval, TimeUnit timeUnit) {
            Preconditions.checkArgument(interval > 0L, "interval (%s) must be positive", interval);
            this.interval = interval;
            this.timeUnit = Preconditions.checkNotNull(timeUnit);
        }

        @Override
        AbstractWatchService newWatchService(FileSystemView view, PathService pathService) {
            return new PollingWatchService(view, pathService, view.state(), this.interval, this.timeUnit);
        }

        public String toString() {
            long l = this.interval;
            String string = String.valueOf((Object)this.timeUnit);
            return new StringBuilder(57 + String.valueOf(string).length()).append("WatchServiceConfiguration.polling(").append(l).append(", ").append(string).append(")").toString();
        }
    }
}

