/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;

class ExtendedClassRemapper
extends ClassRemapper {
    private final MappingSet mappings;
    private final InheritanceProvider inheritanceProvider;
    private final AbstractConsumer abstractConsumer;
    private static final Handle META_FACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;");
    private static final Handle ALT_META_FACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;");

    ExtendedClassRemapper(ClassVisitor classVisitor, Remapper remapper, MappingSet mappings, InheritanceProvider inheritanceProvider, AbstractConsumer abstractConsumer) {
        super(classVisitor, remapper);
        this.mappings = mappings;
        this.inheritanceProvider = inheritanceProvider;
        this.abstractConsumer = abstractConsumer;
    }

    @Override
    public MethodVisitor visitMethod(int access, final String mname, final String mdescriptor, String msignature, String[] exceptions) {
        String remappedDescriptor = this.remapper.mapMethodDesc(mdescriptor);
        MethodVisitor methodVisitor = this.cv.visitMethod(access, this.remapper.mapMethodName(this.className, mname, mdescriptor), remappedDescriptor, this.remapper.mapSignature(msignature, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        if (methodVisitor == null) {
            return null;
        }
        if ((access & 0x500) != 0) {
            this.renameAbstract(access, mname, mdescriptor);
        }
        return new MethodRemapper(methodVisitor, this.remapper){
            private final Map<Integer, Integer> seen;
            {
                super(x0, x1);
                this.seen = new HashMap<Integer, Integer>();
            }

            @Override
            public void visitLocalVariable(String pname, String pdescriptor, String psignature, Label start, Label end, int index) {
                super.visitLocalVariable(this.renameSnowmen(ExtendedClassRemapper.this.mapParameterName(ExtendedClassRemapper.this.className, mname, mdescriptor, index, pname), index), pdescriptor, psignature, start, end, index);
            }

            private String renameSnowmen(String name, int index) {
                if ('\u2603' != name.charAt(0)) {
                    return name;
                }
                int version = this.seen.computeIfAbsent(index, k -> 0) + 1;
                this.seen.put(index, version);
                return "lvt_" + index + '_' + version + '_';
            }

            @Override
            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                if (META_FACTORY.equals(bootstrapMethodHandle) || ALT_META_FACTORY.equals(bootstrapMethodHandle)) {
                    String owner = Type.getReturnType(descriptor).getInternalName();
                    String odesc = ((Type)bootstrapMethodArguments[0]).getDescriptor();
                    Object[] remappedBootstrapMethodArguments = new Object[bootstrapMethodArguments.length];
                    for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
                        remappedBootstrapMethodArguments[i] = this.remapper.mapValue(bootstrapMethodArguments[i]);
                    }
                    this.mv.visitInvokeDynamicInsn(this.remapper.mapMethodName(owner, name, odesc), this.remapper.mapMethodDesc(descriptor), (Handle)this.remapper.mapValue(bootstrapMethodHandle), remappedBootstrapMethodArguments);
                    return;
                }
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }
        };
    }

    private ClassMapping<?, ?> getCompletedClassMapping(String owner) {
        ClassMapping<?, ?> mapping = this.mappings.getOrCreateClassMapping(owner);
        mapping.complete(this.inheritanceProvider);
        return mapping;
    }

    public String mapParameterName(String owner, String methodName, String methodDescriptor, int index, String paramName) {
        return this.getCompletedClassMapping(owner).getMethodMapping(MethodSignature.of(methodName, methodDescriptor)).flatMap(m -> m.getParameterMapping(index)).map(Mapping::getDeobfuscatedName).orElse(paramName);
    }

    private void renameAbstract(int access, String name, String descriptor) {
        Type[] types = Type.getArgumentTypes(descriptor);
        if (types.length == 0) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        int i = (access & 8) == 0 ? 1 : 0;
        for (Type type : types) {
            names.add(this.mapParameterName(this.className, name, descriptor, i, "var" + i));
            i += type.getSize();
        }
        this.abstractConsumer.storeNames(this.remapper.mapType(this.className), this.remapper.mapMethodName(this.className, name, descriptor), this.remapper.mapMethodDesc(descriptor), names);
    }

    static interface AbstractConsumer {
        public void storeNames(String var1, String var2, String var3, Collection<String> var4);
    }
}

