/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.io.srg.xsrg;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.TextMappingsWriter;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.cadixdev.lorenz.model.MethodMapping;

public class XSrgWriter
extends TextMappingsWriter {
    private final List<String> classes = new ArrayList<String>();
    private final List<String> fields = new ArrayList<String>();
    private final List<String> methods = new ArrayList<String>();

    public XSrgWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void write(MappingSet mappings) {
        mappings.getTopLevelClassMappings().stream().filter(ClassMapping::hasMappings).sorted(this.getConfig().getClassMappingComparator()).forEach(this::writeClassMapping);
        this.classes.forEach(this.writer::println);
        this.fields.forEach(this.writer::println);
        this.methods.forEach(this.writer::println);
        this.classes.clear();
        this.fields.clear();
        this.methods.clear();
    }

    protected void writeClassMapping(ClassMapping<?, ?> mapping) {
        if (mapping.hasDeobfuscatedName()) {
            this.classes.add(String.format("CL: %s %s", mapping.getFullObfuscatedName(), mapping.getFullDeobfuscatedName()));
        }
        mapping.getInnerClassMappings().stream().filter(ClassMapping::hasMappings).sorted(this.getConfig().getClassMappingComparator()).forEach(this::writeClassMapping);
        mapping.getFieldMappings().stream().filter(Mapping::hasDeobfuscatedName).sorted(this.getConfig().getFieldMappingComparator()).forEach(this::writeFieldMapping);
        mapping.getMethodMappings().stream().filter(Mapping::hasDeobfuscatedName).sorted(this.getConfig().getMethodMappingComparator()).forEach(this::writeMethodMapping);
    }

    protected void writeFieldMapping(FieldMapping mapping) {
        Optional<FieldType> fieldType = mapping.getType();
        fieldType.ifPresent(type -> this.fields.add(String.format("FD: %s %s %s %s", mapping.getFullObfuscatedName(), type, mapping.getFullDeobfuscatedName(), mapping.getMappings().deobfuscate((FieldType)type))));
    }

    protected void writeMethodMapping(MethodMapping mapping) {
        this.methods.add(String.format("MD: %s %s %s %s", mapping.getFullObfuscatedName(), mapping.getObfuscatedDescriptor(), mapping.getFullDeobfuscatedName(), mapping.getDeobfuscatedDescriptor()));
    }
}

