/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.InvalidLauncherSetupException;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.NameMappingServiceHandler;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.TransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class TransformationServicesHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<String, TransformationServiceDecorator> serviceLookup;
    private final TransformStore transformStore;
    private final ModuleLayerHandler layerHandler;

    TransformationServicesHandler(TransformStore transformStore, ModuleLayerHandler layerHandler) {
        this.transformStore = transformStore;
        this.layerHandler = layerHandler;
    }

    List<ITransformationService.Resource> initializeTransformationServices(ArgumentHandler argumentHandler, Environment environment, NameMappingServiceHandler nameMappingServiceHandler) {
        this.loadTransformationServices(environment);
        this.validateTransformationServices();
        this.processArguments(argumentHandler, environment);
        this.initialiseTransformationServices(environment);
        environment.putPropertyIfAbsent(IEnvironment.Keys.NAMING.get(), "mojang");
        nameMappingServiceHandler.bindNamingServices(environment.getProperty(IEnvironment.Keys.NAMING.get()).orElse("mojang"));
        return this.runScanningTransformationServices(environment);
    }

    TransformingClassLoader buildTransformingClassLoader(LaunchPluginHandler pluginHandler, TransformingClassLoaderBuilder builder, Environment environment, ModuleLayerHandler layerHandler) {
        return (TransformingClassLoader)((Object)layerHandler.build(IModuleLayerManager.Layer.GAME, (cfg, layers, loaders) -> new TransformingClassLoader("TRANSFORMER", null, cfg, layers, loaders, this.transformStore, pluginHandler, environment)).cl());
    }

    private void processArguments(ArgumentHandler argumentHandler, Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Configuring option handling for services");
        argumentHandler.processArguments(environment, this::computeArgumentsForServices, this::offerArgumentResultsToServices);
    }

    private void computeArgumentsForServices(OptionParser parser) {
        this.serviceLookup.values().stream().map(TransformationServiceDecorator::getService).forEach(service -> service.arguments((a, b) -> parser.accepts(service.name() + "." + a, b)));
    }

    private void offerArgumentResultsToServices(OptionSet optionSet, BiFunction<String, OptionSet, ITransformationService.OptionResult> resultHandler) {
        this.serviceLookup.values().stream().map(TransformationServiceDecorator::getService).forEach(service -> service.argumentValues((ITransformationService.OptionResult)resultHandler.apply(service.name(), optionSet)));
    }

    void initialiseServiceTransformers() {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services loading transformers");
        for (TransformationServiceDecorator s : this.serviceLookup.values()) {
            s.gatherTransformers(this.transformStore);
        }
    }

    private void initialiseTransformationServices(Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services initializing");
        for (TransformationServiceDecorator s : this.serviceLookup.values()) {
            s.onInitialize(environment);
        }
    }

    private List<ITransformationService.Resource> runScanningTransformationServices(Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services begin scanning");
        return this.serviceLookup.values().stream().map(s -> s.runScan(environment)).flatMap(Collection::stream).toList();
    }

    private void validateTransformationServices() {
        List<String> failed = this.serviceLookup.values().stream().filter(d -> !d.isValid()).map(d -> d.getService().name()).toList();
        if (!failed.isEmpty()) {
            String names = String.join((CharSequence)", ", failed);
            LOGGER.error(LogMarkers.MODLAUNCHER, "Found {} services that failed to load : [{}]", (Object)failed.size(), (Object)names);
            throw new InvalidLauncherSetupException("Invalid Services found " + names);
        }
    }

    private void loadTransformationServices(Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services loading");
        for (TransformationServiceDecorator s : this.serviceLookup.values()) {
            s.onLoad(environment, this.serviceLookup.keySet());
        }
    }

    void discoverServices(ArgumentHandler.DiscoveryData discoveryData) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Discovering transformation services");
        ModuleLayer bootLayer = this.layerHandler.getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
        ArrayList<ITransformerDiscoveryService> discovery = new ArrayList<ITransformerDiscoveryService>();
        Iterator<ITransformerDiscoveryService> itr = ServiceLoader.load(bootLayer, ITransformerDiscoveryService.class).iterator();
        while (itr.hasNext()) {
            try {
                ITransformerDiscoveryService srvc = itr.next();
                discovery.add(srvc);
                List<NamedPath> paths = srvc.candidates(discoveryData.gameDir(), discoveryData.launchTarget());
                if (paths.isEmpty()) continue;
                LOGGER.debug(LogMarkers.MODLAUNCHER, "Found additional transformation services from discovery service: {}", (Object)srvc.getClass().getName());
                for (NamedPath path : paths) {
                    LOGGER.debug(LogMarkers.MODLAUNCHER, "\t{}", (Object)path.toString());
                    this.layerHandler.addToLayer(IModuleLayerManager.Layer.SERVICE, SecureJar.from((Path[])path.paths()));
                }
            }
            catch (ServiceConfigurationError sce) {
                LOGGER.fatal("Encountered serious error loading transformation discoverer service, expect problems", (Throwable)sce);
            }
        }
        ModuleLayer serviceLayer = this.layerHandler.build(IModuleLayerManager.Layer.SERVICE).layer();
        for (ITransformerDiscoveryService service : discovery) {
            service.earlyInitialization(discoveryData.launchTarget(), discoveryData.arguments());
        }
        HashMap<String, TransformationServiceDecorator> transformers = new HashMap<String, TransformationServiceDecorator>();
        Optional<List<Map<String, String>>> modlist = Launcher.INSTANCE.environment().getProperty(IEnvironment.Keys.MODLIST.get());
        Iterator<ITransformationService> itr2 = ServiceLoader.load(serviceLayer, ITransformationService.class).iterator();
        while (itr2.hasNext()) {
            try {
                ITransformationService srvc = itr2.next();
                transformers.put(srvc.name(), new TransformationServiceDecorator(srvc));
                String file = ServiceLoaderUtils.fileNameFor(srvc.getClass());
                LOGGER.debug(LogMarkers.MODLAUNCHER, "Found transformer service: {}: {}", (Object)srvc.name(), (Object)file);
                if (!modlist.isPresent()) continue;
                modlist.get().add(Map.of("name", srvc.name(), "type", "TRANSFORMATIONSERVICE", "file", file));
            }
            catch (ServiceConfigurationError sce) {
                LOGGER.fatal(LogMarkers.MODLAUNCHER, "Encountered serious error loading transformation service, expect problems", (Throwable)sce);
            }
        }
        this.serviceLookup = transformers;
    }

    public List<ITransformationService.Resource> triggerScanCompletion(IModuleLayerManager moduleLayerManager) {
        return this.serviceLookup.values().stream().map(tsd -> tsd.onCompleteScan(moduleLayerManager)).flatMap(Collection::stream).toList();
    }
}

