/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.roimfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;

class ReadOnlyByteChannel
implements SeekableByteChannel {
    private final byte[] data;
    private boolean isOpen = true;
    private int position = 0;

    ReadOnlyByteChannel(byte[] data) {
        this.data = data;
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    @Override
    public long position() throws IOException {
        this.ensureOpen();
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPosition is negative: " + newPosition);
        }
        if (newPosition > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("newPosition is larger then Integer.MAX_VALUE");
        }
        this.ensureOpen();
        this.position = (int)newPosition;
        if (newPosition > (long)this.data.length) {
            this.position = this.data.length;
        }
        return this;
    }

    @Override
    public long size() throws IOException {
        this.ensureOpen();
        return this.data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        byte[] byArray = this.data;
        synchronized (this.data) {
            this.ensureOpen();
            if (this.position > this.data.length) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return -1;
            }
            int count = dst.remaining();
            if (count > this.data.length - this.position) {
                count = this.data.length - this.position;
            }
            if (count > 0) {
                dst.put(this.data, this.position, count);
                if (count != -1) {
                    this.position += count;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return count;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new NonWritableChannelException();
    }
}

