/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.roimfs;

import java.io.IOException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class RoimDirectoryStream
implements DirectoryStream<Path> {
    private final List<Path> files;
    private final DirectoryStream.Filter<? super Path> filter;
    private volatile boolean isClosed;
    private volatile Iterator<Path> itr;

    RoimDirectoryStream(List<Path> files, DirectoryStream.Filter<? super Path> filter) {
        this.files = files;
        this.filter = filter;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.files.clear();
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.isClosed) {
            throw new ClosedDirectoryStreamException();
        }
        if (this.itr != null) {
            throw new IllegalStateException("Iterator has already been returned");
        }
        this.itr = this.files.iterator();
        return new Iterator<Path>(){
            private Path next = null;

            @Override
            public boolean hasNext() {
                if (RoimDirectoryStream.this.isClosed) {
                    return false;
                }
                while (RoimDirectoryStream.this.itr.hasNext()) {
                    this.next = (Path)RoimDirectoryStream.this.itr.next();
                    try {
                        if (RoimDirectoryStream.this.filter == null || RoimDirectoryStream.this.filter.accept(this.next)) break;
                        this.next = null;
                    }
                    catch (IOException e) {
                        throw new DirectoryIteratorException(e);
                    }
                }
                return this.next != null;
            }

            @Override
            public Path next() {
                if (RoimDirectoryStream.this.isClosed || this.next == null) {
                    throw new NoSuchElementException();
                }
                Path ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

