/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.bus;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.WildcardType;
import net.neoforged.bus.EventListenerFactory;
import net.neoforged.bus.IWrapperListener;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.IGenericEvent;
import net.neoforged.bus.api.SubscribeEvent;
import org.objectweb.asm.Type;

public final class SubscribeEventListener
extends EventListener
implements IWrapperListener {
    private final EventListener handler;
    private final SubscribeEvent subInfo;
    private final boolean isGeneric;
    private String readable;
    private java.lang.reflect.Type filter = null;

    public SubscribeEventListener(Object target, Method method, boolean isGeneric) {
        java.lang.reflect.Type type;
        this.handler = EventListenerFactory.create(method, target);
        this.subInfo = method.getAnnotation(SubscribeEvent.class);
        this.readable = "@SubscribeEvent: " + target + " " + method.getName() + Type.getMethodDescriptor((Method)method);
        this.isGeneric = isGeneric;
        if (isGeneric && (type = method.getGenericParameterTypes()[0]) instanceof ParameterizedType) {
            WildcardType wfilter;
            this.filter = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (this.filter instanceof ParameterizedType) {
                this.filter = ((ParameterizedType)this.filter).getRawType();
            } else if (this.filter instanceof WildcardType && (wfilter = (WildcardType)this.filter).getUpperBounds().length == 1 && wfilter.getUpperBounds()[0] == Object.class && wfilter.getLowerBounds().length == 0) {
                this.filter = null;
            }
        }
    }

    @Override
    public void invoke(Event event) {
        if (this.handler != null) {
            if (this.isGeneric) {
                ICancellableEvent cancellableEvent;
                if (!(this.filter != null && this.filter != ((IGenericEvent)((Object)event)).getGenericType() || event instanceof ICancellableEvent && (cancellableEvent = (ICancellableEvent)((Object)event)).isCanceled())) {
                    this.handler.invoke(event);
                }
            } else if (!((ICancellableEvent)((Object)event)).isCanceled()) {
                this.handler.invoke(event);
            }
        }
    }

    public EventPriority getPriority() {
        return this.subInfo.priority();
    }

    public String toString() {
        return this.readable;
    }

    @Override
    public EventListener getWithoutCheck() {
        return this.handler;
    }
}

