/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.bus.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.neoforged.bus.EventListenerHelper;

public abstract class Event {
    boolean isCanceled = false;
    private Result result = Result.DEFAULT;

    protected Event() {
    }

    public final boolean hasResult() {
        return EventListenerHelper.hasResult(this.getClass());
    }

    public final Result getResult() {
        return this.result;
    }

    public void setResult(Result value) {
        if (!this.hasResult()) {
            throw new UnsupportedOperationException("Attempted to call Event#setResult() on an event without result of type: " + this.getClass().getCanonicalName());
        }
        this.result = value;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Deprecated(forRemoval=true)
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

