/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.error;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.earlydisplay.error.Button;
import net.neoforged.fml.earlydisplay.error.FileOpener;
import net.neoforged.fml.earlydisplay.error.FontLoader;
import net.neoforged.fml.earlydisplay.error.FormatHelper;
import net.neoforged.fml.earlydisplay.render.EarlyFramebuffer;
import net.neoforged.fml.earlydisplay.render.ElementShader;
import net.neoforged.fml.earlydisplay.render.GlState;
import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.SimpleBufferBuilder;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.render.Texture;
import net.neoforged.fml.earlydisplay.theme.Theme;
import net.neoforged.fml.i18n.FMLTranslations;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11C;

final class ErrorDisplayWindow {
    private static final int DISPLAY_WIDTH = 854;
    private static final int DISPLAY_HEIGHT = 480;
    private static final int BUTTON_WIDTH = 320;
    private static final int BUTTON_HEIGHT = 40;
    private static final int LIST_BORDER_HEIGHT = 2;
    private static final int SCROLLER_WIDTH = 15;
    private static final int SCROLLER_HEIGHT = 60;
    private static final int ENTRY_PADDING = 10;
    private static final int HEADER_Y = 10;
    private static final int HEADER_LINE_HEIGHT = 18;
    private static final int LEFT_BTN_X = 97;
    private static final int RIGHT_BTN_X = 437;
    private static final int TOP_BTN_Y = 388;
    private static final int BOTTOM_BTN_Y = 433;
    private static final int LIST_Y_TOP = 70;
    private static final int LIST_Y_BOTTOM = 380;
    private static final int LIST_CONTENT_Y_TOP = 74;
    private static final int LIST_CONTENT_Y_BOTTOM = 378;
    private static final int LIST_BORDER_TOP_Y2 = 68;
    private static final int LIST_BORDER_TOP_Y1 = 66;
    private static final int LIST_BORDER_BOTTOM_Y1 = 380;
    private static final int LIST_BORDER_BOTTOM_Y2 = 382;
    private static final int LIST_HEIGHT = 310;
    private static final int LIST_CONTENT_HEIGHT = 304;
    private static final int LIST_ENTRY_X = 30;
    private static final int SCROLL_SPEED = 10;
    final long windowHandle;
    private final MaterializedTheme theme;
    private final SimpleFont font;
    private final int errorLineHeight;
    private final EarlyFramebuffer framebuffer;
    private final SimpleBufferBuilder bufferBuilder;
    final Texture buttonTexture;
    final Texture buttonTextureHover;
    private final List<Button> buttons;
    private final List<HeaderLine> headerTextLines;
    private final List<MessageEntry> entries;
    private final int totalEntryHeight;
    private boolean closed = false;
    private int offsetX = 0;
    private int offsetY = 0;
    private float scale = 1.0f;
    private double mouseX = -1.0;
    private double mouseY = -1.0;
    private float scrollOffset = 0.0f;
    private boolean draggingScrollbar = false;

    ErrorDisplayWindow(long windowHandle, @Nullable String assetsDir, @Nullable String assetIndex, List<ModLoadingIssue> issues, Path modsFolder, Path logFile, Path crashReportFile) {
        int headerTextColor;
        String headerText;
        this.windowHandle = windowHandle;
        this.theme = MaterializedTheme.materialize(Theme.createDefaultTheme(), null);
        SimpleFont mcFont = FontLoader.loadVanillaFont(assetsDir, assetIndex);
        this.font = mcFont != null ? mcFont : this.theme.getFont("default");
        this.errorLineHeight = this.font.lineSpacing() - 5;
        this.framebuffer = new EarlyFramebuffer(854, 480);
        this.bufferBuilder = new SimpleBufferBuilder("shared_error", 8192);
        this.buttonTexture = Button.loadTexture(false);
        this.buttonTextureHover = Button.loadTexture(true);
        boolean translate = mcFont != null;
        BiFunction<String, Object[], String> translator = translate ? FMLTranslations::parseMessage : FMLTranslations::parseEnglishMessage;
        FileOpener opener = FileOpener.get();
        String btnModsText = translator.apply("fml.button.open.mods.folder", new Object[0]);
        String btnReportText = translator.apply("fml.button.open.crashreport", new Object[0]);
        String btnLogText = translator.apply("fml.button.open.log", new Object[0]);
        String btnQuitText = translator.apply("fml.button.quit", new Object[0]);
        this.buttons = List.of(new Button(this, 97, 388, 320, 40, btnModsText, () -> opener.open(modsFolder)), new Button(this, 97, 433, 320, 40, btnReportText, () -> opener.open(crashReportFile)), new Button(this, 437, 388, 320, 40, btnLogText, () -> opener.open(logFile)), new Button(this, 437, 433, 320, 40, btnQuitText, () -> {
            this.closed = true;
        }));
        List<ModLoadingIssue> warningEntries = issues.stream().filter(issue -> issue.severity() != ModLoadingIssue.Severity.ERROR).toList();
        List<ModLoadingIssue> errorEntries = issues.stream().filter(issue -> issue.severity() == ModLoadingIssue.Severity.ERROR).toList();
        String errorHeaderText = translator.apply("fml.loadingerrorscreen.errorheader", new Object[]{errorEntries.size()});
        String warningHeaderText = translator.apply("fml.loadingerrorscreen.warningheader", new Object[]{warningEntries.size()});
        boolean needSeparators = !warningEntries.isEmpty() && !errorEntries.isEmpty();
        Function<ModLoadingIssue, String> issueTranslator = translate ? FMLTranslations::translateIssue : FMLTranslations::translateIssueEnglish;
        this.entries = new ArrayList<MessageEntry>(errorEntries.size() + warningEntries.size());
        if (needSeparators) {
            this.entries.add(MessageEntry.of(errorHeaderText, -43691, true));
        }
        ErrorDisplayWindow.translateEntries(errorEntries, this.entries, issueTranslator);
        if (needSeparators) {
            this.entries.add(MessageEntry.of(warningHeaderText, -171, true));
        }
        ErrorDisplayWindow.translateEntries(warningEntries, this.entries, issueTranslator);
        int entryContentHeight = this.entries.stream().mapToInt(MessageEntry::lineCount).sum() * this.errorLineHeight;
        this.totalEntryHeight = entryContentHeight + this.entries.size() * 10;
        if (!errorEntries.isEmpty()) {
            headerText = errorHeaderText;
            headerTextColor = -43691;
        } else {
            headerText = warningHeaderText;
            headerTextColor = -171;
        }
        this.headerTextLines = HeaderLine.of(headerText, this.font, headerTextColor);
    }

    private static void translateEntries(List<ModLoadingIssue> issues, List<MessageEntry> entries, Function<ModLoadingIssue, String> translator) {
        issues.stream().map(translator).map(MessageEntry::of).forEach(entries::add);
    }

    void render() {
        this.framebuffer.activate();
        int[] fbWidth = new int[1];
        int[] fbHeight = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.windowHandle, (int[])fbWidth, (int[])fbHeight);
        this.framebuffer.resize(fbWidth[0], fbHeight[0]);
        float desiredAspectRatio = 1.7791667f;
        float actualAspectRatio = (float)this.framebuffer.width() / (float)this.framebuffer.height();
        if (actualAspectRatio > desiredAspectRatio) {
            float actualWidth = desiredAspectRatio * (float)this.framebuffer.height();
            this.offsetX = (int)((float)this.framebuffer.width() - actualWidth) / 2;
            this.offsetY = 0;
            this.scale = (float)this.framebuffer.height() / 480.0f;
            GlState.viewport(this.offsetX, 0, (int)actualWidth, this.framebuffer.height());
        } else {
            float actualHeight = (float)this.framebuffer.width() / desiredAspectRatio;
            this.offsetX = 0;
            this.offsetY = (int)((float)this.framebuffer.height() - actualHeight) / 2;
            this.scale = (float)this.framebuffer.width() / 854.0f;
            GlState.viewport(0, this.offsetY, this.framebuffer.width(), (int)actualHeight);
        }
        GlState.clearColor(0.0f, 0.0f, 0.0f, 1.0f);
        GL11C.glClear((int)16640);
        GlState.enableBlend(true);
        GlState.blendFuncSeparate(770, 771, 0, 1);
        RenderContext ctx = new RenderContext(this.bufferBuilder, this.theme, 854.0f, 480.0f, 0);
        for (ElementShader shader : this.theme.shaders().values()) {
            shader.activate();
            if (!shader.hasUniform("screenSize")) continue;
            shader.setUniform2f("screenSize", 854.0f, 480.0f);
        }
        this.renderToFramebuffer(ctx);
        this.framebuffer.deactivate();
        GlState.viewport(0, 0, this.framebuffer.width(), this.framebuffer.height());
        this.framebuffer.blitToScreen(this.theme.theme().colorScheme().screenBackground(), this.framebuffer.width(), this.framebuffer.height());
        GLFW.glfwSwapBuffers((long)this.windowHandle);
    }

    private void renderToFramebuffer(RenderContext ctx) {
        ctx.fillRect(0.0f, 0.0f, 854.0f, 480.0f, -12574688, -11530224);
        ctx.fillRect(0.0f, 66.0f, 854.0f, 2.0f, 0x33FFFFFF);
        ctx.fillRect(0.0f, 68.0f, 854.0f, 2.0f, -1090519040);
        ctx.fillRect(0.0f, 380.0f, 854.0f, 2.0f, -1090519040);
        ctx.fillRect(0.0f, 382.0f, 854.0f, 2.0f, 0x33FFFFFF);
        ctx.fillRect(0.0f, 70.0f, 854.0f, 310.0f, 0x70000000);
        for (int i = 0; i < this.headerTextLines.size(); ++i) {
            HeaderLine line = this.headerTextLines.get(i);
            float x = 427.0f - (float)line.width / 2.0f;
            float y = 10 + 18 * i;
            ctx.renderTextWithShadow(x, y, this.font, line.parts);
        }
        GlState.scissorTest(true);
        GlState.scissorBox(this.offsetX, (int)((float)this.offsetY + 74.0f * this.scale), (int)(854.0f * this.scale), (int)(304.0f * this.scale));
        float y = 70.0f - this.scrollOffset;
        for (MessageEntry entry : this.entries) {
            float entryHeight = this.errorLineHeight * entry.lineCount();
            if (y + entryHeight < 70.0f) {
                y += entryHeight + 10.0f;
                continue;
            }
            if (y > 378.0f) break;
            for (List<SimpleFont.DisplayText> line : entry.lines()) {
                float textX;
                if (entry.centered) {
                    int width = line.stream().map(SimpleFont.DisplayText::string).mapToInt(this.font::stringWidth).sum();
                    textX = 427.0f - (float)width / 2.0f;
                } else {
                    textX = 30.0f;
                }
                ctx.renderText(textX, y, this.font, line);
                y += (float)this.errorLineHeight;
            }
            y += 10.0f;
        }
        GlState.scissorTest(false);
        if (this.totalEntryHeight > 304) {
            float scrollFactor = this.scrollOffset / (float)(this.totalEntryHeight - 304 - 1);
            float scrollerY = 70.0f + scrollFactor * 249.0f;
            ctx.fillRect(839.0f, scrollerY, 15.0f, 60.0f, -5592406);
        }
        this.buttons.forEach(btn -> btn.render(ctx, this.font, this.mouseX, this.mouseY));
    }

    private void dragScrollbar(double mouseY) {
        double maxOff = this.totalEntryHeight - 304;
        double offset = (mouseY - 70.0 - 30.0) / 244.0;
        this.scrollOffset = (float)Math.clamp(offset * maxOff, 0.0, maxOff);
    }

    private void scroll(double delta) {
        float offY = (float)(delta * 10.0);
        this.scrollOffset = Math.clamp(this.scrollOffset + offY, 0.0f, (float)Math.max(this.totalEntryHeight - 304, 0));
    }

    void handleCursorPos(long ignoredWindow, double mouseX, double mouseY) {
        this.mouseX = (mouseX - (double)this.offsetX) / (double)this.scale;
        this.mouseY = (mouseY - (double)this.offsetY) / (double)this.scale;
        if (this.draggingScrollbar) {
            this.dragScrollbar(this.mouseY);
        }
    }

    void handleMouseScroll(long ignoredWindow, double ignoredDeltaX, double deltaY) {
        this.scroll(-deltaY);
    }

    void handleMouseButton(long ignoredWindow, int button, int action, int ignoredMods) {
        boolean press;
        if (button != 0) {
            return;
        }
        boolean bl = press = action == 1;
        if (press) {
            this.buttons.forEach(Button::unfocus);
            for (Button btn : this.buttons) {
                if (!btn.isMouseOver(this.mouseX, this.mouseY)) continue;
                btn.onPress.run();
                break;
            }
        }
        if (this.totalEntryHeight > 304) {
            if (press && this.mouseX > 839.0 && this.mouseY > 70.0 && this.mouseY <= 380.0) {
                this.draggingScrollbar = true;
                this.dragScrollbar(this.mouseY);
            } else if (!press) {
                this.draggingScrollbar = false;
            }
        }
    }

    void handleKey(long ignoredWindow, int key, int ignoredScancode, int action, int ignoredMods) {
        if (action == 0) {
            return;
        }
        boolean repeat = action == 2;
        block0 : switch (key) {
            case 256: {
                if (repeat) break;
                this.closed = true;
                break;
            }
            case 265: 
            case 266: {
                this.scroll(-1.0);
                break;
            }
            case 264: 
            case 267: {
                this.scroll(1.0);
                break;
            }
            case 258: {
                if (repeat) break;
                boolean modified = false;
                for (int i = 0; i < this.buttons.size(); ++i) {
                    Button button = this.buttons.get(i);
                    if (!button.isFocused()) continue;
                    button.unfocus();
                    this.buttons.get((i + 1) % this.buttons.size()).focus();
                    modified = true;
                    break;
                }
                if (modified) break;
                this.buttons.getFirst().focus();
                break;
            }
            case 257: 
            case 335: {
                if (repeat) break;
                for (Button button : this.buttons) {
                    if (!button.isFocused()) continue;
                    button.onPress.run();
                    break block0;
                }
                break;
            }
        }
    }

    void handleClose(long ignoredWindow) {
        this.closed = true;
    }

    boolean isClosed() {
        return this.closed;
    }

    void teardown() {
        this.theme.close();
        this.framebuffer.close();
        this.bufferBuilder.close();
        this.buttonTexture.close();
        this.buttonTextureHover.close();
        SimpleBufferBuilder.destroy();
    }

    private record MessageEntry(List<List<SimpleFont.DisplayText>> lines, int lineCount, boolean centered) {
        static MessageEntry of(String text) {
            return MessageEntry.of(text, -1, false);
        }

        static MessageEntry of(String text, int defaultColor, boolean centered) {
            List<List<SimpleFont.DisplayText>> lines = FormatHelper.formatText(text, defaultColor);
            return new MessageEntry(lines, lines.size(), centered);
        }
    }

    private record HeaderLine(List<SimpleFont.DisplayText> parts, int width) {
        static List<HeaderLine> of(String text, SimpleFont font, int defaultColor) {
            ArrayList<HeaderLine> headerLines = new ArrayList<HeaderLine>();
            for (List<SimpleFont.DisplayText> line : FormatHelper.formatText(text, defaultColor)) {
                int width = 0;
                for (SimpleFont.DisplayText part : line) {
                    width += font.stringWidth(part.string());
                }
                headerLines.add(new HeaderLine(line, width));
            }
            return headerLines;
        }
    }
}

