/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.neoforged.fml.earlydisplay.render.GlDebug;
import net.neoforged.fml.earlydisplay.render.GlState;
import net.neoforged.fml.earlydisplay.theme.NativeBuffer;
import net.neoforged.fml.earlydisplay.theme.ThemeResource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL32C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementShader
implements AutoCloseable {
    public static final String UNIFORM_SCREEN_SIZE = "screenSize";
    public static final String UNIFORM_SAMPLER0 = "tex";
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementShader.class);
    private final String name;
    private int program;
    private final Map<String, Integer> uniformLocations;
    private final Set<String> warnedAboutUniforms = new HashSet<String>();

    private ElementShader(String name, int program, Map<String, Integer> uniformLocations) {
        this.name = name;
        this.program = program;
        this.uniformLocations = uniformLocations;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ElementShader create(String name, ThemeResource vertexShader, ThemeResource fragmentShader, @Nullable Path externalThemeDirectory) {
        try (NativeBuffer vertexShaderBuffer = vertexShader.toNativeBuffer(externalThemeDirectory);){
            NativeBuffer fragmentShaderBuffer = fragmentShader.toNativeBuffer(externalThemeDirectory);
            try {
                ElementShader elementShader = ElementShader.create(name, vertexShaderBuffer.buffer(), fragmentShaderBuffer.buffer());
                if (fragmentShaderBuffer != null) {
                    fragmentShaderBuffer.close();
                }
                return elementShader;
            }
            catch (Throwable throwable) {
                if (fragmentShaderBuffer != null) {
                    try {
                        fragmentShaderBuffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read shaders for " + name);
        }
    }

    public static ElementShader create(String name, ByteBuffer vertexShaderSource, ByteBuffer fragmentShaderSource) {
        int vertexShader = GL32C.glCreateShader((int)35633);
        GlDebug.labelShader(vertexShader, "FML " + name + ".vert");
        int fragmentShader = GL32C.glCreateShader((int)35632);
        GlDebug.labelShader(fragmentShader, "FML " + name + ".frag");
        PointerBuffer sourcePointers = PointerBuffer.allocateDirect((int)1);
        sourcePointers.put(0, fragmentShaderSource);
        GL32C.glShaderSource((int)fragmentShader, (PointerBuffer)sourcePointers, (int[])new int[]{fragmentShaderSource.remaining()});
        sourcePointers.put(0, vertexShaderSource);
        GL32C.glShaderSource((int)vertexShader, (PointerBuffer)sourcePointers, (int[])new int[]{vertexShaderSource.remaining()});
        GL32C.glCompileShader((int)vertexShader);
        if (GL32C.glGetShaderi((int)vertexShader, (int)35713) == 0) {
            throw new IllegalStateException("VertexShader linkage failure. \n" + GL32C.glGetShaderInfoLog((int)vertexShader));
        }
        GL32C.glCompileShader((int)fragmentShader);
        if (GL32C.glGetShaderi((int)fragmentShader, (int)35713) == 0) {
            throw new IllegalStateException("FragmentShader linkage failure. \n" + GL32C.glGetShaderInfoLog((int)fragmentShader));
        }
        int program = GL32C.glCreateProgram();
        GlDebug.labelProgram(program, "EarlyDisplay program");
        GL32C.glBindAttribLocation((int)program, (int)0, (CharSequence)"position");
        GL32C.glBindAttribLocation((int)program, (int)1, (CharSequence)"uv");
        GL32C.glBindAttribLocation((int)program, (int)2, (CharSequence)"color");
        GL32C.glAttachShader((int)program, (int)vertexShader);
        GL32C.glAttachShader((int)program, (int)fragmentShader);
        GL32C.glLinkProgram((int)program);
        if (GL32C.glGetProgrami((int)program, (int)35714) == 0) {
            throw new RuntimeException("ShaderProgram linkage failure. \n" + GL32C.glGetProgramInfoLog((int)program));
        }
        GL32C.glDetachShader((int)program, (int)vertexShader);
        GL32C.glDetachShader((int)program, (int)fragmentShader);
        GL32C.glDeleteShader((int)vertexShader);
        GL32C.glDeleteShader((int)fragmentShader);
        int uniformCount = GL32C.glGetProgrami((int)program, (int)35718);
        HashMap<String, Integer> uniformLocations = new HashMap<String, Integer>(uniformCount);
        for (int i = 0; i < uniformCount; ++i) {
            String uniformName = GL32C.glGetActiveUniformName((int)program, (int)i);
            uniformLocations.put(uniformName, i);
        }
        return new ElementShader(name, program, uniformLocations);
    }

    public void activate() {
        GlState.useProgram(this.program);
    }

    public void clear() {
        GlState.useProgram(0);
    }

    public boolean hasUniform(String name) {
        return this.uniformLocations.containsKey(name);
    }

    public void setUniform1i(String name, int value) {
        Integer location = this.uniformLocations.get(name);
        if (location != null) {
            GL32C.glUniform1i((int)location, (int)value);
        } else {
            this.warnAboutMissingUniform(name);
        }
    }

    public void setUniform2f(String name, float x, float y) {
        Integer location = this.uniformLocations.get(name);
        if (location != null) {
            GL32C.glUniform2f((int)location, (float)x, (float)y);
        } else {
            this.warnAboutMissingUniform(name);
        }
    }

    private void warnAboutMissingUniform(String name) {
        if (this.warnedAboutUniforms.add(name)) {
            LOGGER.error("Missing uniform '{}' in shader '{}'", (Object)name, (Object)this);
        }
    }

    @Override
    public void close() {
        if (this.program > 0) {
            GL32C.glDeleteProgram((int)this.program);
            this.program = 0;
        }
    }

    public int program() {
        return this.program;
    }

    public String toString() {
        return this.name;
    }
}

