/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render.elements;

import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.Texture;
import net.neoforged.fml.earlydisplay.render.elements.RenderElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeImageElement;
import net.neoforged.fml.earlydisplay.util.Bounds;

public class ImageElement
extends RenderElement {
    private final Texture texture;

    public ImageElement(ThemeImageElement element, MaterializedTheme theme) {
        super(element, theme);
        this.texture = Texture.create(element.texture(), theme.externalThemeDirectory());
    }

    @Override
    public void render(RenderContext context) {
        int color = -1;
        if ("squir".equals(this.id())) {
            int fade = (int)(Math.cos((double)context.animationFrame() * Math.PI / 16.0) * 16.0) + 16;
            color = (fade & 0xFF) << 24 | 0xFFFFFF;
        }
        Bounds bounds = this.resolveBounds(context.availableWidth(), context.availableHeight(), this.texture.width(), this.texture.height());
        context.blitTexture(this.texture, bounds, color);
    }

    @Override
    public void close() {
        this.texture.close();
    }
}

