/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render.elements;

import java.io.IOException;
import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.Texture;
import net.neoforged.fml.earlydisplay.render.elements.RenderElement;
import net.neoforged.fml.earlydisplay.theme.ImageLoader;
import net.neoforged.fml.earlydisplay.theme.NativeBuffer;
import net.neoforged.fml.earlydisplay.theme.TextureScaling;
import net.neoforged.fml.earlydisplay.theme.ThemeMojangLogoElement;
import net.neoforged.fml.earlydisplay.theme.UncompressedImage;
import net.neoforged.fml.earlydisplay.util.Bounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojangLogoElement
extends RenderElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(MojangLogoElement.class);
    private static final String[] LOGO_PATHS = new String[]{"assets/minecraft/textures/gui/title/mojangstudios.png"};
    private final Texture mojangLogo;

    public MojangLogoElement(ThemeMojangLogoElement element, MaterializedTheme theme) {
        super(element, theme);
        ClassLoader[] classLoaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()};
        Texture mojangLogo = null;
        block11: for (String logoPath : LOGO_PATHS) {
            for (ClassLoader classLoader : classLoaders) {
                try (NativeBuffer buffer = NativeBuffer.loadFromClasspath(logoPath, classLoader);){
                    Object image;
                    Object object;
                    ImageLoader.Result loadResult = ImageLoader.tryLoadImage("mojang logo", null, buffer);
                    if (loadResult instanceof ImageLoader.Result.Error) {
                        ImageLoader.Result.Error error = (ImageLoader.Result.Error)loadResult;
                        object = error.exception();
                        Exception exception = object;
                        LOGGER.debug("Failed to load Mojang logo from {}: {}", (Object)logoPath, (Object)exception);
                        continue;
                    }
                    if (!(loadResult instanceof ImageLoader.Result.Success)) continue;
                    ImageLoader.Result.Success success = (ImageLoader.Result.Success)loadResult;
                    try {
                        image = object = success.image();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    mojangLogo = Texture.create((UncompressedImage)image, "mojang logo", new TextureScaling.Stretch(512, 128, true), null);
                    continue block11;
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to load Mojang logo from {}", (Object)logoPath);
                }
            }
        }
        if (mojangLogo == null) {
            LOGGER.warn("Failed to find Mojang logo at any of the expected classpath locations.");
        }
        this.mojangLogo = mojangLogo;
    }

    @Override
    public void render(RenderContext context) {
        if (this.mojangLogo == null) {
            return;
        }
        Bounds bounds = this.resolveBounds(context.availableWidth(), context.availableHeight(), 512.0f, 128.0f);
        float x0 = bounds.left();
        float x1 = (bounds.left() + bounds.right()) / 2.0f;
        float x2 = bounds.right();
        context.blitTextureRegion(this.mojangLogo, x0, bounds.top(), x1 - x0, bounds.height(), -1, 0.0f, 1.0f, 0.0f, 0.5f);
        context.blitTextureRegion(this.mojangLogo, x1, bounds.top(), x2 - x1, bounds.height(), -1, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    @Override
    public void close() {
        if (this.mojangLogo != null) {
            this.mojangLogo.close();
        }
    }
}

