/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render.elements;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.render.elements.RenderElement;
import net.neoforged.fml.earlydisplay.theme.ThemeColor;
import net.neoforged.fml.earlydisplay.theme.elements.ThemePerformanceElement;
import net.neoforged.fml.earlydisplay.util.Bounds;
import net.neoforged.fml.earlydisplay.util.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceElement
extends RenderElement {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceElement.class);
    private static final long REFRESH_AFTER_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private final OperatingSystemMXBean osBean;
    private final MemoryMXBean memoryBean;
    private Future<Void> performanceUpdateFuture;
    private volatile PerformanceInfo currentPerformanceData;

    public PerformanceElement(ThemePerformanceElement settings, MaterializedTheme theme) {
        super(settings, theme);
        this.setId("performance");
        this.osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.performanceUpdateFuture = CompletableFuture.runAsync(this::updatePerformanceData);
    }

    @Override
    public void render(RenderContext context) {
        PerformanceInfo performanceData = this.currentPerformanceData;
        long now = System.nanoTime();
        if (performanceData != null && performanceData.createdNanos + REFRESH_AFTER_NANOS < now && this.performanceUpdateFuture.isDone()) {
            this.performanceUpdateFuture = CompletableFuture.runAsync(this::updatePerformanceData);
        } else if (performanceData == null) {
            return;
        }
        Bounds areaBounds = this.resolveBounds(context.availableWidth(), context.availableHeight(), 250.0f, 50.0f);
        float memoryBarFill = performanceData.memory();
        ThemeColor color = ThemeColor.lerp(this.theme.theme().colorScheme().memoryLowColor(), this.theme.theme().colorScheme().memoryHighColor(), memoryBarFill);
        Bounds barBounds = new Bounds(areaBounds.left(), areaBounds.top(), areaBounds.right(), areaBounds.top() + (float)this.theme.sprites().progressBarBackground().height());
        context.renderProgressBar(barBounds, memoryBarFill, color.toArgb());
        Size textMeasurement = this.font.measureText(performanceData.text());
        context.renderText((int)(areaBounds.horizontalCenter() - textMeasurement.width() / 2.0f), barBounds.bottom(), this.font, List.of(new SimpleFont.DisplayText(performanceData.text(), this.theme.theme().colorScheme().text().toArgb())));
    }

    @Override
    public void close() {
        super.close();
        this.performanceUpdateFuture.cancel(false);
    }

    private void updatePerformanceData() {
        try {
            MemoryUsage heapusage = this.memoryBean.getHeapMemoryUsage();
            float memory = (float)heapusage.getUsed() / (float)heapusage.getMax();
            double cpuLoad = this.osBean.getProcessCpuLoad();
            String cpuText = cpuLoad == -1.0 ? String.format(Locale.ROOT, "*CPU: %d%%", Math.round(this.osBean.getCpuLoad() * 100.0)) : String.format(Locale.ROOT, "CPU: %d%%", Math.round(cpuLoad * 100.0));
            String text = String.format(Locale.ROOT, "Memory: %d/%d MB (%d%%)  %s", heapusage.getUsed() >> 20, heapusage.getMax() >> 20, Math.round((double)memory * 100.0), cpuText);
            this.currentPerformanceData = new PerformanceInfo(System.nanoTime(), memory, text);
        }
        catch (Exception e) {
            LOG.error("Failed to update performance data.", (Throwable)e);
        }
    }

    private record PerformanceInfo(long createdNanos, float memory, String text) {
    }
}

