/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render.elements;

import java.util.List;
import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.render.elements.RenderElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeProgressBarsElement;
import net.neoforged.fml.earlydisplay.util.Bounds;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;

public class ProgressBarsElement
extends RenderElement {
    private static final int BAR_AREA_WIDTH = 400;
    private static final int BAR_AREA_HEIGHT = 200;
    private final ThemeProgressBarsElement settings;

    public ProgressBarsElement(ThemeProgressBarsElement settings, MaterializedTheme theme) {
        super(settings, theme);
        this.settings = settings;
    }

    @Override
    public void render(RenderContext context) {
        Bounds areaBounds = this.resolveBounds(context.availableWidth(), context.availableHeight(), 400.0f, 200.0f);
        float yOffset = 0.0f;
        int barsShown = 0;
        for (ProgressMeter progress : StartupNotificationManager.getCurrentProgress()) {
            if (++barsShown > 2) break;
            String text = progress.label().getText();
            if (!text.isEmpty()) {
                context.renderText(areaBounds.left(), areaBounds.top() + yOffset, this.font, List.of(new SimpleFont.DisplayText(text, this.theme.theme().colorScheme().text().toArgb())));
                yOffset += (float)(this.font.lineSpacing() + this.settings.labelGap());
            }
            Bounds barBounds = new Bounds(areaBounds.left(), areaBounds.top() + yOffset, areaBounds.right(), areaBounds.top() + yOffset + (float)this.theme.sprites().progressBarBackground().height());
            if (progress.steps() == 0) {
                context.renderIndeterminateProgressBar(barBounds);
            } else {
                context.renderProgressBar(barBounds, progress.progress());
            }
            yOffset += barBounds.height() + (float)this.settings.barGap();
        }
    }
}

