/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.theme;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.neoforged.fml.earlydisplay.theme.TextureScaling;
import net.neoforged.fml.earlydisplay.theme.Theme;
import net.neoforged.fml.earlydisplay.theme.ThemeColor;
import net.neoforged.fml.earlydisplay.theme.ThemeResource;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeDecorativeElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeImageElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeLabelElement;
import net.neoforged.fml.earlydisplay.util.StyleLength;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThemeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ThemeLoader.class);
    private static final int VERSION = 1;
    private static final String BUILTIN_PREFIX = "builtin:";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(TextureScaling.class, (Object)new TextureScalingSerializer()).registerTypeAdapterFactory((TypeAdapterFactory)new ThemeElementAdapterFactory()).registerTypeHierarchyAdapter(ThemeResource.class, (Object)new ThemeResourceAdapter()).registerTypeAdapter(StyleLength.class, (Object)new StyleLengthAdapter()).registerTypeAdapter(ThemeColor.class, (Object)new ThemeColorAdapter()).create();

    private ThemeLoader() {
    }

    public static Theme load(@Nullable Path externalThemeDirectory, String id) throws IOException {
        LinkedHashSet<String> sources = new LinkedHashSet<String>();
        JsonObject themeTree = ThemeLoader.readThemeTree(externalThemeDirectory, id, sources);
        try {
            return (Theme)GSON.fromJson((JsonElement)themeTree, Theme.class);
        }
        catch (Exception e) {
            throw new IOException("Failed to load theme '" + id + "' from JSON structure.", e);
        }
    }

    private static JsonObject readThemeTree(@Nullable Path externalThemeDirectory, String id, Set<String> sources) throws IOException {
        if (id.startsWith(BUILTIN_PREFIX)) {
            id = id.substring(BUILTIN_PREFIX.length());
            return ThemeLoader.readBuiltinThemeTree(externalThemeDirectory, id, sources);
        }
        if (externalThemeDirectory != null) {
            String filename = ThemeLoader.getThemeFilename(id);
            Path themePath = externalThemeDirectory.resolve(filename);
            try (InputStream in = ThemeLoader.openIfExists(themePath);){
                if (in != null) {
                    if (!sources.add(id)) {
                        throw new IllegalStateException("Detected recursion in theme extends clause: " + String.valueOf(sources) + " -> " + id);
                    }
                    LOG.debug("Loading theme from {}", (Object)themePath);
                    JsonObject jsonObject = ThemeLoader.readThemeTree(externalThemeDirectory, in, sources);
                    return jsonObject;
                }
            }
        }
        return ThemeLoader.readBuiltinThemeTree(externalThemeDirectory, id, sources);
    }

    private static JsonObject readBuiltinThemeTree(@Nullable Path externalThemeDirectory, String id, Set<String> sources) throws IOException {
        if (!sources.add(BUILTIN_PREFIX + id)) {
            throw new IllegalStateException("Detected recursion in theme extends clause: " + String.valueOf(sources) + " -> builtin:" + id);
        }
        String classpathLocation = "/net/neoforged/fml/earlydisplay/theme/" + ThemeLoader.getThemeFilename(id);
        try (InputStream in = ThemeLoader.class.getResourceAsStream(classpathLocation);){
            LOG.debug("Loading built-in theme {}", (Object)id);
            if (in == null) {
                throw new NoSuchFileException("Failed to find embedded theme resource " + classpathLocation);
            }
            JsonObject jsonObject = ThemeLoader.readThemeTree(externalThemeDirectory, in, sources);
            return jsonObject;
        }
    }

    @Nullable
    private static InputStream openIfExists(Path themePath) throws IOException {
        try {
            return Files.newInputStream(themePath, new OpenOption[0]);
        }
        catch (NoSuchFileException ignored) {
            return null;
        }
    }

    private static JsonObject readThemeTree(@Nullable Path externalThemeDirectory, InputStream in, Set<String> sources) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        JsonObject themeRoot = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        Integer themeVersion = ThemeLoader.takeInt((JsonElement)themeRoot, "version");
        if (themeVersion == null || themeVersion != 1) {
            throw new JsonParseException("Expected theme version 1 but found: " + themeVersion);
        }
        String extendsId = ThemeLoader.takeString((JsonElement)themeRoot, "extends");
        if (extendsId != null) {
            JsonObject baseThemeRoot = ThemeLoader.readThemeTree(externalThemeDirectory, extendsId, sources);
            themeRoot = ThemeLoader.mergeThemeRoot(baseThemeRoot, themeRoot);
        }
        return themeRoot;
    }

    private static JsonObject mergeThemeRoot(JsonObject baseThemeRoot, JsonObject themeRoot) {
        return ThemeLoader.mergeObject((JsonElement)baseThemeRoot, (JsonElement)themeRoot, (property, baseValue, value) -> switch (property) {
            case "fonts", "shaders", "colorScheme", "sprites" -> ThemeLoader.mergeObject(baseValue, value);
            case "loadingScreen" -> ThemeLoader.mergeObject(baseValue, value, ThemeLoader::mergeLoadingScreenProperty);
            default -> value;
        });
    }

    private static JsonElement mergeLoadingScreenProperty(String property, JsonElement baseValue, JsonElement value) {
        return ThemeLoader.mergeObject(baseValue, value);
    }

    private static JsonObject mergeObject(JsonElement baseObject, JsonElement object) {
        return ThemeLoader.mergeObject(baseObject, object, (property, baseValue, value) -> value);
    }

    private static JsonObject mergeObject(JsonElement baseObject, JsonElement object, PropertyMerger propertyMerger) {
        JsonObject objectObj = object.getAsJsonObject();
        JsonObject baseObjectObj = baseObject.getAsJsonObject();
        for (Map.Entry entry : objectObj.entrySet()) {
            JsonElement baseValue = baseObjectObj.get((String)entry.getKey());
            if (baseValue == null) {
                baseObjectObj.add((String)entry.getKey(), (JsonElement)entry.getValue());
                continue;
            }
            baseObjectObj.add((String)entry.getKey(), propertyMerger.map((String)entry.getKey(), baseValue, (JsonElement)entry.getValue()));
        }
        return baseObjectObj;
    }

    private static String getThemeFilename(String id) {
        return "theme-" + id + ".json";
    }

    @Nullable
    private static Integer takeInt(JsonElement el, String field) {
        JsonPrimitive primitive = ThemeLoader.takePrimitive(el, field);
        return primitive == null ? null : Integer.valueOf(primitive.getAsInt());
    }

    @Nullable
    private static String takeString(JsonElement el, String field) {
        JsonPrimitive primitive = ThemeLoader.takePrimitive(el, field);
        return primitive == null ? null : primitive.getAsString();
    }

    private static JsonPrimitive takePrimitive(JsonElement el, String field) {
        if (!el.isJsonObject()) {
            throw new JsonParseException("Expected  " + String.valueOf(el) + " to be an object.");
        }
        JsonObject obj = (JsonObject)el;
        JsonElement v = obj.remove(field);
        if (v == null) {
            return null;
        }
        if (!(v instanceof JsonPrimitive)) {
            throw new JsonParseException("Expected " + field + " of " + String.valueOf(el) + " to be a primitive");
        }
        JsonPrimitive primitive = (JsonPrimitive)v;
        return primitive;
    }

    public static void save(Path path, Theme theme) {
        LOG.info("Saving theme to {}", (Object)path);
        JsonObject themeTree = (JsonObject)GSON.toJsonTree((Object)theme);
        JsonObject merged = new JsonObject();
        merged.addProperty("version", (Number)1);
        for (Map.Entry entry : themeTree.entrySet()) {
            merged.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        try (BufferedWriter out = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)merged, (Appendable)out);
        }
        catch (IOException e) {
            LOG.error("Failed to save theme to {}", (Object)path, (Object)e);
        }
    }

    @FunctionalInterface
    private static interface PropertyMerger {
        public JsonElement map(String var1, JsonElement var2, JsonElement var3);
    }

    private static class TextureScalingSerializer
    implements JsonSerializer<TextureScaling>,
    JsonDeserializer<TextureScaling> {
        private TextureScalingSerializer() {
        }

        public TextureScaling deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String type;
            return switch (type = ((JsonObject)json).getAsJsonPrimitive("type").getAsString()) {
                case "nine_slice" -> (TextureScaling)context.deserialize(json, TextureScaling.NineSlice.class);
                case "stretch" -> (TextureScaling)context.deserialize(json, TextureScaling.Stretch.class);
                case "tile" -> (TextureScaling)context.deserialize(json, TextureScaling.Tile.class);
                default -> throw new JsonParseException("Unknown image type " + type);
            };
        }

        public JsonElement serialize(TextureScaling src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            TextureScaling textureScaling = src;
            Objects.requireNonNull(textureScaling);
            TextureScaling textureScaling2 = textureScaling;
            int n = 0;
            obj.addProperty("type", switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextureScaling.NineSlice.class, TextureScaling.Stretch.class, TextureScaling.Tile.class}, (Object)textureScaling2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    TextureScaling.NineSlice ignored = (TextureScaling.NineSlice)textureScaling2;
                    yield "nine_slice";
                }
                case 1 -> {
                    TextureScaling.Stretch ignored = (TextureScaling.Stretch)textureScaling2;
                    yield "stretch";
                }
                case 2 -> {
                    TextureScaling.Tile ignored = (TextureScaling.Tile)textureScaling2;
                    yield "tile";
                }
            });
            for (Map.Entry entry : ((JsonObject)context.serialize((Object)src, src.getClass())).entrySet()) {
                if ("type".equals(entry.getKey())) {
                    throw new IllegalStateException("Cannot serialize texture scaling with 'type' property");
                }
                obj.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return obj;
        }
    }

    private static class ThemeElementAdapterFactory
    implements TypeAdapterFactory {
        private static final Map<String, Class<? extends ThemeDecorativeElement>> TYPE_MAP = Map.of("image", ThemeImageElement.class, "label", ThemeLabelElement.class);

        private ThemeElementAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type == null) {
                return null;
            }
            if (!ThemeDecorativeElement.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter jsonElementAdapter = gson.getAdapter(JsonElement.class);
            final HashMap<String, TypeAdapter> labelToDelegate = new HashMap<String, TypeAdapter>();
            final HashMap<Class<? extends ThemeDecorativeElement>, TypeAdapter> subtypeToDelegate = new HashMap<Class<? extends ThemeDecorativeElement>, TypeAdapter>();
            final HashMap<Class<? extends ThemeDecorativeElement>, String> subtypeToLabel = new HashMap<Class<? extends ThemeDecorativeElement>, String>();
            for (Map.Entry<String, Class<? extends ThemeDecorativeElement>> entry : TYPE_MAP.entrySet()) {
                TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(entry.getValue()));
                labelToDelegate.put(entry.getKey(), delegate);
                subtypeToDelegate.put(entry.getValue(), delegate);
                subtypeToLabel.put(entry.getValue(), entry.getKey());
            }
            return new TypeAdapter<ThemeDecorativeElement>(this){

                public ThemeDecorativeElement read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)jsonElementAdapter.read(in);
                    JsonElement labelJsonElement = jsonElement.getAsJsonObject().remove("type");
                    if (labelJsonElement == null) {
                        throw new JsonParseException("cannot deserialize theme element because it does not define a type field at " + in.getPath());
                    }
                    String label = labelJsonElement.getAsString();
                    TypeAdapter delegate = (TypeAdapter)labelToDelegate.get(label);
                    if (delegate == null) {
                        throw new JsonParseException("unknown theme element type '" + label + "'. known types: " + String.valueOf(labelToDelegate.keySet()));
                    }
                    return (ThemeDecorativeElement)delegate.fromJsonTree(jsonElement);
                }

                public void write(JsonWriter out, ThemeDecorativeElement value) throws IOException {
                    Class<?> srcType = value.getClass();
                    String label = (String)subtypeToLabel.get(srcType);
                    TypeAdapter delegate = (TypeAdapter)subtypeToDelegate.get(srcType);
                    if (delegate == null) {
                        throw new JsonParseException("cannot serialize theme element " + srcType.getName());
                    }
                    JsonObject jsonObject = delegate.toJsonTree((Object)value).getAsJsonObject();
                    JsonObject clone = new JsonObject();
                    if (jsonObject.has("type")) {
                        throw new JsonParseException("theme element " + String.valueOf(value) + " must not define its own type field");
                    }
                    clone.add("type", (JsonElement)new JsonPrimitive(label));
                    for (Map.Entry e : jsonObject.entrySet()) {
                        clone.add((String)e.getKey(), (JsonElement)e.getValue());
                    }
                    jsonElementAdapter.write(out, (Object)clone);
                }
            }.nullSafe();
        }
    }

    private static class ThemeResourceAdapter
    extends TypeAdapter<ThemeResource> {
        private ThemeResourceAdapter() {
        }

        public ThemeResource read(JsonReader in) throws IOException {
            return new ThemeResource(in.nextString());
        }

        public void write(JsonWriter out, ThemeResource value) throws IOException {
            out.value(value.path());
        }
    }

    private static class StyleLengthAdapter
    extends TypeAdapter<StyleLength> {
        private StyleLengthAdapter() {
        }

        public void write(JsonWriter out, StyleLength value) throws IOException {
            switch (value.unit()) {
                case UNDEFINED: {
                    out.nullValue();
                    break;
                }
                case POINT: {
                    out.value(value.value());
                    break;
                }
                case REM: {
                    out.value(value.value() + "rem");
                    break;
                }
                case PERCENT: {
                    out.value(value.value() + "%");
                }
            }
        }

        public StyleLength read(JsonReader in) throws IOException {
            return switch (in.peek()) {
                case JsonToken.NULL -> StyleLength.ofUndefined();
                case JsonToken.STRING -> {
                    String value = in.nextString();
                    if (value.endsWith("%")) {
                        yield StyleLength.ofPercent(Float.parseFloat(value.substring(0, value.length() - 1)));
                    }
                    if (value.endsWith("rem")) {
                        yield StyleLength.ofREM(Float.parseFloat(value.substring(0, value.length() - 3)));
                    }
                    throw new JsonParseException("Unexpected value: " + value);
                }
                case JsonToken.NUMBER -> StyleLength.ofPoints((float)in.nextDouble());
                default -> throw new JsonParseException("Unexpected token type @ " + in.getPath());
            };
        }
    }

    private static class ThemeColorAdapter
    extends TypeAdapter<ThemeColor> {
        private ThemeColorAdapter() {
        }

        public void write(JsonWriter out, ThemeColor value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                Object hexColor;
                if (value.a() == 1.0f) {
                    hexColor = Integer.toHexString(value.toArgb() & 0xFFFFFF);
                    hexColor = "#" + "0".repeat(Math.max(0, 6 - ((String)hexColor).length())) + (String)hexColor;
                } else {
                    hexColor = Integer.toHexString(value.toArgb());
                    hexColor = "#" + "0".repeat(Math.max(0, 8 - ((String)hexColor).length())) + (String)hexColor;
                }
                out.value((String)hexColor);
            }
        }

        public ThemeColor read(JsonReader in) throws IOException {
            String text = in.nextString();
            if (!text.startsWith("#")) {
                throw new JsonParseException("Cannot parse theme color value '" + text + "'");
            }
            if ((text = text.substring(1)).length() <= 6) {
                return ThemeColor.ofRgb(Integer.parseUnsignedInt(text, 16));
            }
            return ThemeColor.ofArgb(Integer.parseUnsignedInt(text, 16));
        }
    }
}

