/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.util;

public final class StyleLength {
    private static final StyleLength UNDEFINED = new StyleLength(Unit.UNDEFINED, Float.NaN);
    private final Unit unit;
    private final float value;

    private StyleLength(Unit unit, float value) {
        this.unit = unit;
        this.value = value;
    }

    public static StyleLength ofUndefined() {
        return UNDEFINED;
    }

    public static StyleLength ofPoints(float points) {
        if (Float.isNaN(points)) {
            return StyleLength.ofUndefined();
        }
        return new StyleLength(Unit.POINT, points);
    }

    public static StyleLength ofREM(float rem) {
        if (Float.isNaN(rem)) {
            return StyleLength.ofUndefined();
        }
        return new StyleLength(Unit.REM, rem);
    }

    public static StyleLength ofPercent(float percent) {
        if (Float.isNaN(percent)) {
            return StyleLength.ofUndefined();
        }
        return new StyleLength(Unit.PERCENT, percent);
    }

    public Unit unit() {
        return this.unit;
    }

    public float value() {
        return this.value;
    }

    public String toString() {
        return switch (this.unit.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "undefined";
            case 1 -> String.valueOf(this.value);
            case 2 -> this.value + "rem";
            case 3 -> this.value + "%";
        };
    }

    public static enum Unit {
        UNDEFINED,
        POINT,
        REM,
        PERCENT;

    }
}

