/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.neoforged.fml.earlydisplay.GlDebug;
import net.neoforged.fml.earlydisplay.GlState;
import net.neoforged.fml.earlydisplay.STBHelper;
import net.neoforged.fml.earlydisplay.SimpleBufferBuilder;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.stb.STBTTAlignedQuad;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTTPackContext;
import org.lwjgl.stb.STBTTPackRange;
import org.lwjgl.stb.STBTTPackedchar;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.Struct;

public class SimpleFont {
    private final int textureId;
    private final int lineSpacing;
    private final int descent;
    private final int GLYPH_COUNT = 95;
    private Glyph[] glyphs;

    public SimpleFont(String fontName, int scale, int bufferSize) {
        ByteBuffer buf = STBHelper.readFromClasspath(fontName, bufferSize);
        STBTTFontinfo info = STBTTFontinfo.create();
        if (!STBTruetype.stbtt_InitFont((STBTTFontinfo)info, (ByteBuffer)buf)) {
            throw new IllegalStateException("Bad font");
        }
        float[] ascent = new float[1];
        float[] descent = new float[1];
        float[] lineGap = new float[1];
        int fontSize = 24;
        STBTruetype.stbtt_GetScaledFontVMetrics((ByteBuffer)buf, (int)0, (float)fontSize, (float[])ascent, (float[])descent, (float[])lineGap);
        this.lineSpacing = (int)(ascent[0] - descent[0] + lineGap[0]);
        this.descent = (int)Math.floor(descent[0]);
        this.textureId = GL32C.glGenTextures();
        GlState.activeTexture(33984);
        GlState.bindTexture2D(this.textureId);
        GlDebug.labelTexture(this.textureId, "font texture " + fontName);
        try (STBTTPackedchar.Buffer packedchars = STBTTPackedchar.malloc((int)95);){
            int texwidth = 256;
            int texheight = 128;
            try (STBTTPackRange.Buffer packRanges = STBTTPackRange.malloc((int)1);){
                ByteBuffer bitmap = BufferUtils.createByteBuffer((int)(texwidth * texheight));
                try (STBTTPackRange packRange = STBTTPackRange.malloc();){
                    packRanges.put((Struct)packRange.set((float)fontSize, 32, null, 95, packedchars, (byte)1, (byte)1));
                    packRanges.flip();
                }
                try (STBTTPackContext pc = STBTTPackContext.malloc();){
                    STBTruetype.stbtt_PackBegin((STBTTPackContext)pc, (ByteBuffer)bitmap, (int)texwidth, (int)texheight, (int)0, (int)1, (long)0L);
                    STBTruetype.stbtt_PackSetOversampling((STBTTPackContext)pc, (int)1, (int)1);
                    STBTruetype.stbtt_PackSetSkipMissingCodepoints((STBTTPackContext)pc, (boolean)true);
                    STBTruetype.stbtt_PackFontRanges((STBTTPackContext)pc, (ByteBuffer)buf, (int)0, (STBTTPackRange.Buffer)packRanges);
                    STBTruetype.stbtt_PackEnd((STBTTPackContext)pc);
                    GL32C.glTexImage2D((int)3553, (int)0, (int)6403, (int)texwidth, (int)texheight, (int)0, (int)6403, (int)5121, (ByteBuffer)bitmap);
                    GL32C.glTexParameteri((int)3553, (int)10242, (int)33071);
                    GL32C.glTexParameteri((int)3553, (int)10243, (int)33071);
                    GL32C.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL32C.glTexParameteri((int)3553, (int)10241, (int)9729);
                }
            }
            try (STBTTAlignedQuad q = STBTTAlignedQuad.malloc();){
                float[] x = new float[1];
                float[] y = new float[1];
                this.glyphs = new Glyph[95];
                for (int i = 0; i < 95; ++i) {
                    x[0] = 0.0f;
                    y[0] = fontSize;
                    STBTruetype.stbtt_GetPackedQuad((STBTTPackedchar.Buffer)packedchars, (int)texwidth, (int)texheight, (int)i, (float[])x, (float[])y, (STBTTAlignedQuad)q, (boolean)true);
                    this.glyphs[i] = new Glyph((char)(i + 32), (int)(x[0] - 0.0f), new int[]{(int)q.x0(), (int)q.y0(), (int)q.x1(), (int)q.y1()}, new float[]{q.s0(), q.t0(), q.s1(), q.t1()});
                }
            }
        }
    }

    int lineSpacing() {
        return this.lineSpacing;
    }

    int textureId() {
        return this.textureId;
    }

    int descent() {
        return this.descent;
    }

    public int stringWidth(String text) {
        byte[] bytes = text.getBytes(StandardCharsets.US_ASCII);
        int len = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte c = bytes[i];
            len += (switch (c) {
                case 9, 10 -> 0;
                case 32 -> this.glyphs[0].charwidth();
                default -> c - 32 < this.GLYPH_COUNT && c > 32 ? this.glyphs[c - 32].charwidth() : 0;
            });
        }
        return len;
    }

    public SimpleBufferBuilder generateVerticesForTexts(int x, int y, SimpleBufferBuilder textBB, DisplayText ... texts) {
        Pos pos = new Pos(x, y, x);
        for (DisplayText text : texts) {
            pos = text.generateStringArray(this, pos, textBB);
        }
        return textBB;
    }

    private record Glyph(char c, int charwidth, int[] pos, float[] uv) {
        Pos loadQuad(Pos pos, int colour, SimpleBufferBuilder bb) {
            int x0 = pos.x() + this.pos()[0];
            int y0 = pos.y() + this.pos()[1];
            int x1 = pos.x() + this.pos()[2];
            int y1 = pos.y() + this.pos()[3];
            bb.pos(x0, y0).tex(this.uv()[0], this.uv()[1]).colour(colour).endVertex();
            bb.pos(x1, y0).tex(this.uv()[2], this.uv()[1]).colour(colour).endVertex();
            bb.pos(x0, y1).tex(this.uv()[0], this.uv()[3]).colour(colour).endVertex();
            bb.pos(x1, y1).tex(this.uv()[2], this.uv()[3]).colour(colour).endVertex();
            return new Pos(pos.x() + this.charwidth(), pos.y(), pos.minx());
        }
    }

    private record Pos(int x, int y, int minx) {
    }

    public record DisplayText(String string, int colour) {
        private byte[] asBytes() {
            return this.string.getBytes(StandardCharsets.US_ASCII);
        }

        Pos generateStringArray(SimpleFont font, Pos pos, SimpleBufferBuilder bb) {
            for (int i = 0; i < this.asBytes().length; ++i) {
                byte c = this.asBytes()[i];
                pos = switch (c) {
                    case 10 -> new Pos(pos.minx(), pos.y() + font.lineSpacing(), pos.minx());
                    case 9 -> new Pos(pos.x() + font.glyphs[0].charwidth() * 4, pos.y(), pos.minx());
                    case 32 -> new Pos(pos.x() + font.glyphs[0].charwidth(), pos.y(), pos.minx());
                    default -> {
                        if (c - 32 < font.GLYPH_COUNT && c > 32) {
                            pos = font.glyphs[c - 32].loadQuad(pos, this.colour(), bb);
                        }
                        yield pos;
                    }
                };
            }
            return pos;
        }
    }
}

