/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.neoforged.fml.classloading.JlsConstants;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ModuleDescriptorFactory {
    private ModuleDescriptorFactory() {
    }

    public static void scanAutomaticModule(JarContents jar, ModuleDescriptor.Builder builder, String ... excludedRootDirectories) {
        Set<String> ignoredRootDirs = Set.of(excludedRootDirectories);
        HashSet<String> packageNames = new HashSet<String>();
        HashMap serviceProviderFiles = new HashMap();
        jar.visitContent((relativePath, resource) -> {
            String relativeDir;
            String packageName;
            int lastSeparator;
            if (relativePath.startsWith("META-INF/services/")) {
                String filename = relativePath.substring(relativePath.lastIndexOf(47) + 1);
                if (JlsConstants.isTypeName(filename)) {
                    serviceProviderFiles.put(filename, resource.retain());
                }
            } else if (relativePath.endsWith(".class") && (lastSeparator = relativePath.lastIndexOf(47)) > 0 && JlsConstants.isTypeName(packageName = (relativeDir = relativePath.substring(0, lastSeparator)).replace('/', '.'))) {
                packageNames.add(packageName);
            }
        });
        builder.packages(packageNames);
        for (Map.Entry serviceProviderEntry : serviceProviderFiles.entrySet()) {
            String serviceProviderName = (String)serviceProviderEntry.getKey();
            try {
                BufferedReader reader = ((JarResource)serviceProviderEntry.getValue()).bufferedReader(StandardCharsets.UTF_8);
                try {
                    ModuleDescriptorFactory.parseServiceFile(serviceProviderName, reader, packageNames, builder);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to parse service provider file " + serviceProviderName + " in " + String.valueOf(jar), e);
            }
        }
    }

    private static void parseServiceFile(String serviceName, BufferedReader reader, Set<String> packageNames, ModuleDescriptor.Builder builder) throws IOException {
        String line;
        ArrayList<String> providerClasses = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            int startOfComment = line.indexOf(35);
            if (startOfComment != -1) {
                line = line.substring(0, startOfComment);
            }
            if ((line = line.trim()).isEmpty()) continue;
            String packageName = JlsConstants.getPackageName(line);
            if (!packageNames.contains(packageName)) {
                String msg = "Service provider file " + serviceName + " contains service that is not in this Jar file: " + line;
                throw new InvalidModuleDescriptorException(msg);
            }
            providerClasses.add(line);
        }
        if (!providerClasses.isEmpty()) {
            builder.provides(serviceName, providerClasses);
        }
    }

    public static Set<String> scanModulePackages(JarContents jar) {
        HashSet packageNames = new HashSet();
        jar.visitContent((relativePath, resource) -> {
            int lastSeparator = relativePath.lastIndexOf(47);
            if (lastSeparator < 1) {
                return;
            }
            String packageName = relativePath.substring(0, lastSeparator).replace('/', '.');
            if (JlsConstants.isTypeName(packageName)) {
                packageNames.add(packageName);
            }
        });
        return Set.copyOf(packageNames);
    }
}

