/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import net.neoforged.fml.classloading.SecureJar;
import net.neoforged.fml.jarcontents.JarContents;
import org.jetbrains.annotations.Nullable;

public final class VirtualJar
implements SecureJar {
    private final JarContents contents;
    private final ModuleDescriptor moduleDescriptor;
    private final SecureJar.ModuleDataProvider moduleData = new VirtualJarModuleDataProvider();
    private final Manifest manifest = new Manifest();

    public VirtualJar(String name, String ... packages) {
        this.contents = JarContents.empty(Path.of("VirtualJar/" + name, new String[0]));
        this.moduleDescriptor = ModuleDescriptor.newAutomaticModule(name).packages(Set.of(packages)).build();
    }

    @Override
    public SecureJar.ModuleDataProvider moduleDataProvider() {
        return this.moduleData;
    }

    @Override
    public Path getPrimaryPath() {
        return this.contents.getPrimaryPath();
    }

    @Override
    public JarContents contents() {
        return this.contents;
    }

    @Override
    public String name() {
        return this.moduleDescriptor.name();
    }

    @Override
    public void close() throws IOException {
    }

    private class VirtualJarModuleDataProvider
    implements SecureJar.ModuleDataProvider {
        private VirtualJarModuleDataProvider() {
        }

        @Override
        public String name() {
            return VirtualJar.this.name();
        }

        @Override
        public ModuleDescriptor descriptor() {
            return VirtualJar.this.moduleDescriptor;
        }

        @Override
        @Nullable
        public URI uri() {
            return null;
        }

        @Override
        public Optional<URI> findFile(String name) {
            return Optional.empty();
        }

        @Override
        public Optional<InputStream> open(String name) {
            return Optional.empty();
        }

        @Override
        public Manifest getManifest() {
            return VirtualJar.this.manifest;
        }
    }
}

