/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.common.asm.enumextension;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.asm.ListGeneratorAdapter;
import net.neoforged.fml.common.asm.enumextension.EnumParameters;
import net.neoforged.fml.common.asm.enumextension.EnumPrototype;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import net.neoforged.fml.common.asm.enumextension.IndexedEnum;
import net.neoforged.fml.common.asm.enumextension.NamedEnum;
import net.neoforged.fml.common.asm.enumextension.NetworkedEnum;
import net.neoforged.fml.common.asm.enumextension.ReservedConstructor;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

@ApiStatus.Internal
public class RuntimeEnumExtender
implements ClassProcessor {
    private static final Type MARKER_IFACE = Type.getType(IExtensibleEnum.class);
    private static final Type INDEXED_ANNOTATION = Type.getType(IndexedEnum.class);
    private static final Type NAMED_ANNOTATION = Type.getType(NamedEnum.class);
    private static final Type RESERVED_ANNOTATION = Type.getType(ReservedConstructor.class);
    private static final Type ENUM_PROXY = Type.getType(EnumProxy.class);
    private static final Type NET_CHECK = Type.getType(NetworkedEnum.NetworkCheck.class);
    private static final Type EXT_INFO = Type.getType(ExtensionInfo.class);
    private static final String EXT_INFO_GETTER_DESC = Type.getMethodDescriptor((Type)EXT_INFO, (Type[])new Type[0]);
    private static final String EXT_INFO_CTOR_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE, Type.INT_TYPE, Type.INT_TYPE, NET_CHECK});
    private static final Type NETWORKED_ANNOTATION = Type.getType(NetworkedEnum.class);
    private static final Type EXTENDER = Type.getType(RuntimeEnumExtender.class);
    private static final Type ARRAYS = Type.getType((String)"Ljava/util/Arrays;");
    private static final int ENUM_FLAGS = 16409;
    private static final int ARRAY_FLAGS = 4122;
    private static final int EXT_INFO_FLAGS = 26;
    private static Map<String, List<EnumPrototype>> prototypes = Map.of();

    @Override
    public ProcessorName name() {
        return ClassProcessorIds.RUNTIME_ENUM_EXTENDER;
    }

    @Override
    public Set<ProcessorName> runsBefore() {
        return Set.of(ClassProcessorIds.MIXIN);
    }

    @Override
    public ClassProcessor.OrderingHint orderingHint() {
        return ClassProcessor.OrderingHint.EARLY;
    }

    @Override
    public boolean handlesClass(ClassProcessor.SelectionContext context) {
        return !context.empty() && prototypes.containsKey(context.type().getInternalName());
    }

    @Override
    public ClassProcessor.ComputeFlags processClass(ClassProcessor.TransformationContext context) {
        ClassNode classNode = context.node();
        Type classType = context.type();
        if ((classNode.access & 0x4000) == 0 || !classNode.interfaces.contains(MARKER_IFACE.getInternalName())) {
            throw new IllegalStateException("Tried to extend non-enum class or non-extensible enum: " + String.valueOf(classType));
        }
        List<EnumPrototype> protos = prototypes.getOrDefault(classType.getInternalName(), List.of());
        if (protos.isEmpty()) {
            return ClassProcessor.ComputeFlags.NO_REWRITE;
        }
        MethodNode clinit = RuntimeEnumExtender.findMethod(classNode, mth -> mth.name.equals("<clinit>"));
        Optional<MethodNode> $valuesOpt = RuntimeEnumExtender.tryFindMethod(classNode, mth -> mth.name.equals("$values"));
        boolean $valuesPresent = $valuesOpt.isPresent();
        MethodNode getExtInfo = RuntimeEnumExtender.findMethod(classNode, mth -> mth.name.equals("getExtensionInfo") && mth.desc.equals(EXT_INFO_GETTER_DESC));
        Set<String> ctors = classNode.methods.stream().filter(mth -> mth.name.equals("<init>")).filter(RuntimeEnumExtender::isAllowedConstructor).map(mth -> mth.desc).collect(Collectors.toSet());
        int vanillaEntryCount = RuntimeEnumExtender.getVanillaEntryCount(classNode, classType);
        int idParamIdx = RuntimeEnumExtender.getParameterIndexFromAnnotation(classNode, INDEXED_ANNOTATION);
        int nameParamIdx = RuntimeEnumExtender.getParameterIndexFromAnnotation(classNode, NAMED_ANNOTATION);
        if (idParamIdx != -1 && idParamIdx == nameParamIdx) {
            throw new IllegalStateException("ID and name parameter cannot have the same index on enum " + String.valueOf(classType));
        }
        FieldNode infoField = new FieldNode(26, "FML$ENUM_EXT_INFO", EXT_INFO.getDescriptor(), null, null);
        classNode.fields.add(infoField);
        RuntimeEnumExtender.clearMethod(getExtInfo);
        InsnList getExtInfoInsnList = getExtInfo.instructions;
        getExtInfoInsnList.add((AbstractInsnNode)new FieldInsnNode(178, classType.getInternalName(), infoField.name, infoField.desc));
        getExtInfoInsnList.add((AbstractInsnNode)new InsnNode(176));
        ListGeneratorAdapter clinitGenerator = new ListGeneratorAdapter(new InsnList());
        List<FieldNode> enumEntries = RuntimeEnumExtender.createEnumEntries(classType, clinitGenerator, ctors, idParamIdx, nameParamIdx, vanillaEntryCount, protos);
        if ($valuesPresent) {
            MethodNode $values = $valuesOpt.get();
            MethodInsnNode $valuesInsn = RuntimeEnumExtender.findFirstStaticMethodCall(clinit, classType.getInternalName(), $values.name, $values.desc);
            clinit.instructions.insertBefore((AbstractInsnNode)$valuesInsn, clinitGenerator.insnList);
        } else {
            AbstractInsnNode firstValuesArrayInsn = RuntimeEnumExtender.findValuesArrayCreation(classType, clinit);
            clinit.instructions.insertBefore(firstValuesArrayInsn, clinitGenerator.insnList);
        }
        ListGeneratorAdapter clinitTailGenerator = new ListGeneratorAdapter(new InsnList());
        RuntimeEnumExtender.buildExtensionInfo(classNode, classType, clinitTailGenerator, infoField, vanillaEntryCount, protos.size());
        RuntimeEnumExtender.returnValuesToExtender(classType, clinitTailGenerator, protos, enumEntries);
        AbstractInsnNode clinitRetNode = RuntimeEnumExtender.findFirstInstructionBefore(clinit, 177, clinit.instructions.size() - 1);
        clinit.instructions.insertBefore(clinitRetNode, clinitTailGenerator.insnList);
        classNode.fields.addAll(vanillaEntryCount, enumEntries);
        ListGeneratorAdapter appendValuesGenerator = new ListGeneratorAdapter(new InsnList());
        RuntimeEnumExtender.appendValuesArray(classType, appendValuesGenerator, enumEntries);
        if ($valuesPresent) {
            MethodNode $values = $valuesOpt.get();
            AbstractInsnNode $valuesAretInsn = RuntimeEnumExtender.findFirstInstructionBefore($values, 176, $values.instructions.size() - 1);
            $values.instructions.insertBefore($valuesAretInsn, appendValuesGenerator.insnList);
        } else {
            FieldInsnNode putStaticInsn = RuntimeEnumExtender.findValuesArrayStore(classType, classNode, clinit, classType.getInternalName());
            clinit.instructions.insertBefore((AbstractInsnNode)putStaticInsn, appendValuesGenerator.insnList);
        }
        return ClassProcessor.ComputeFlags.COMPUTE_FRAMES;
    }

    public static MethodInsnNode findFirstStaticMethodCall(MethodNode method, String owner, String name, String descriptor) {
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode node = method.instructions.get(i);
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (node.getOpcode() != 184 || !methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name) || !methodInsnNode.desc.equals(descriptor)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, int opCode, int startIndex) {
        for (int i = Math.max(method.instructions.size() - 1, startIndex); i >= 0; --i) {
            AbstractInsnNode ain = method.instructions.get(i);
            if (ain.getOpcode() != opCode) continue;
            return ain;
        }
        return null;
    }

    private static Optional<MethodNode> tryFindMethod(ClassNode classNode, Predicate<MethodNode> predicate) {
        return classNode.methods.stream().filter(predicate).findFirst();
    }

    private static MethodNode findMethod(ClassNode classNode, Predicate<MethodNode> predicate) {
        return RuntimeEnumExtender.tryFindMethod(classNode, predicate).orElseThrow();
    }

    private static FieldNode findField(ClassNode classNode, Predicate<FieldNode> predicate) {
        return classNode.fields.stream().filter(predicate).findFirst().orElseThrow();
    }

    private static void clearMethod(MethodNode mth) {
        mth.instructions.clear();
        mth.localVariables.clear();
        if (mth.tryCatchBlocks != null) {
            mth.tryCatchBlocks.clear();
        }
        if (mth.visibleLocalVariableAnnotations != null) {
            mth.visibleLocalVariableAnnotations.clear();
        }
        if (mth.invisibleLocalVariableAnnotations != null) {
            mth.invisibleLocalVariableAnnotations.clear();
        }
    }

    private static int getVanillaEntryCount(ClassNode classNode, Type classType) {
        return (int)classNode.fields.stream().takeWhile(field -> (field.access & 0x4019) == 16409 && field.desc.equals(classType.getDescriptor())).count();
    }

    private static int getParameterIndexFromAnnotation(ClassNode classNode, Type annoType) {
        if (classNode.invisibleAnnotations == null) {
            return -1;
        }
        AnnotationNode annotation = classNode.invisibleAnnotations.stream().filter(anno -> anno.desc.equals(annoType.getDescriptor())).findFirst().orElse(null);
        if (annotation == null) {
            return -1;
        }
        if (annotation.values == null) {
            return 0;
        }
        for (int i = 0; i < annotation.values.size(); i += 2) {
            if (!annotation.values.get(i).equals("value")) continue;
            return (Integer)annotation.values.get(i + 1);
        }
        return 0;
    }

    private static boolean isAllowedConstructor(MethodNode mth) {
        if (mth.invisibleAnnotations == null) {
            return true;
        }
        AnnotationNode annotation = mth.invisibleAnnotations.stream().filter(anno -> anno.desc.equals(RESERVED_ANNOTATION.getDescriptor())).findFirst().orElse(null);
        return annotation == null;
    }

    private static AbstractInsnNode findValuesArrayCreation(Type classType, MethodNode clinit) {
        for (int i = 0; i < clinit.instructions.size(); ++i) {
            AbstractInsnNode ain = clinit.instructions.get(i);
            if (ain.getOpcode() != 189 || !(ain instanceof TypeInsnNode)) continue;
            TypeInsnNode tin = (TypeInsnNode)ain;
            if (!tin.desc.equals(classType.getInternalName())) continue;
            return tin.getPrevious();
        }
        throw new NoSuchElementException("Failed to locate values array creation in enum " + String.valueOf(classType));
    }

    private static FieldInsnNode findValuesArrayStore(Type classType, ClassNode classNode, MethodNode mth, String owner) {
        String arrayDesc = Type.getType((String)("[" + classType.getDescriptor())).getDescriptor();
        FieldNode valuesArray = RuntimeEnumExtender.findField(classNode, field -> (field.access & 0x101A) == 4122 && field.desc.equals(arrayDesc));
        for (int i = 0; i < mth.instructions.size(); ++i) {
            AbstractInsnNode ain = mth.instructions.get(i);
            if (ain.getOpcode() != 179 || !(ain instanceof FieldInsnNode)) continue;
            FieldInsnNode fin = (FieldInsnNode)ain;
            if (!fin.desc.equals(valuesArray.desc) || !fin.name.equals(valuesArray.name) || !fin.owner.equals(owner)) continue;
            return fin;
        }
        throw new NoSuchElementException();
    }

    private static List<FieldNode> createEnumEntries(Type classType, ListGeneratorAdapter generator, Set<String> ctors, int idParamIdx, int nameParamIdx, int vanillaEntryCount, List<EnumPrototype> prototypes) {
        ArrayList<FieldNode> enumFields = new ArrayList<FieldNode>(prototypes.size());
        int ordinal = vanillaEntryCount;
        for (EnumPrototype proto : prototypes) {
            if (!ctors.contains(proto.fullCtorDesc())) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid, non-existant or disallowed constructor '%s' for field '%s' in enum '%s' specified by mod '%s'", proto.ctorDesc(), proto.fieldName(), proto.enumName(), proto.owningMod()));
            }
            String fieldName = proto.fieldName();
            FieldNode field = new FieldNode(16409, fieldName, classType.getDescriptor(), null, null);
            enumFields.add(field);
            generator.newInstance(classType);
            generator.dup();
            generator.push(fieldName);
            generator.push(ordinal);
            RuntimeEnumExtender.loadConstructorParams(generator, idParamIdx, nameParamIdx, ordinal, proto);
            generator.invokeConstructor(classType, new Method("<init>", proto.fullCtorDesc()));
            generator.putStatic(classType, field.name, classType);
            ++ordinal;
        }
        return enumFields;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadConstructorParams(ListGeneratorAdapter generator, int idParamIdx, int nameParamIdx, int ordinal, EnumPrototype proto) {
        Type[] argTypes = Type.getType((String)proto.fullCtorDesc()).getArgumentTypes();
        EnumParameters enumParameters = proto.ctorParams();
        Objects.requireNonNull(enumParameters);
        EnumParameters enumParameters2 = enumParameters;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnumParameters.FieldReference.class, EnumParameters.MethodReference.class, EnumParameters.Constant.class}, (Object)enumParameters2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object fieldName;
                Type owner;
                EnumParameters.FieldReference fieldReference = (EnumParameters.FieldReference)enumParameters2;
                try {
                    Object object;
                    owner = object = fieldReference.owner();
                    fieldName = object = fieldReference.fieldName();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                for (int idx = 2; idx < argTypes.length; ++idx) {
                    if (idx - 2 == idParamIdx) {
                        generator.push(ordinal);
                        continue;
                    }
                    generator.getStatic(owner, (String)fieldName, ENUM_PROXY);
                    generator.push(idx - 2);
                    generator.invokeVirtual(ENUM_PROXY, new Method("getParameter", "(I)Ljava/lang/Object;"));
                    generator.unbox(argTypes[idx]);
                    if (idx - 2 != nameParamIdx) continue;
                    generator.push(proto.owningMod());
                    generator.invokeStatic(EXTENDER, new Method("validateNameParameter", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"));
                }
                return;
            }
            case 1: {
                Object methodName;
                Type owner;
                EnumParameters.MethodReference methodReference = (EnumParameters.MethodReference)enumParameters2;
                {
                    Object object;
                    owner = object = methodReference.owner();
                    methodName = object = methodReference.methodName();
                }
                for (int idx = 2; idx < argTypes.length; ++idx) {
                    if (idx - 2 == idParamIdx) {
                        generator.push(ordinal);
                        continue;
                    }
                    generator.push(idx - 2);
                    generator.push(argTypes[idx]);
                    generator.invokeStatic(owner, new Method((String)methodName, "(ILjava/lang/Class;)Ljava/lang/Object;"));
                    generator.unbox(argTypes[idx]);
                    if (idx - 2 != nameParamIdx) continue;
                    generator.push(proto.owningMod());
                    generator.invokeStatic(EXTENDER, new Method("validateNameParameter", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"));
                }
                return;
            }
            case 2: {
                List<Object> paramList;
                EnumParameters.Constant constant = (EnumParameters.Constant)enumParameters2;
                {
                    List<Object> list;
                    paramList = list = constant.params();
                }
                block23: for (int idx = 2; idx < argTypes.length; ++idx) {
                    Object object;
                    if (idx - 2 == idParamIdx) {
                        Integer i;
                        object = paramList.get(idx - 2);
                        if (!(object instanceof Integer) || (i = (Integer)object) != -1) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected -1 as ID parameter at index %d in parameters for field '%s' in enum '%s' specified by mod '%s'", idx - 2, proto.fieldName(), proto.enumName(), proto.owningMod()));
                        }
                        generator.push(ordinal);
                        continue;
                    }
                    if (idx - 2 == nameParamIdx) {
                        object = paramList.get(idx - 2);
                        if (!(object instanceof String)) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected String at index %d in parameters for field '%s' in enum '%s' specified by mod '%s'", idx - 2, proto.fieldName(), proto.enumName(), proto.owningMod()));
                        }
                        String str = (String)object;
                        RuntimeEnumExtender.validateNameParameter(str, proto.owningMod());
                    }
                    Object object2 = paramList.get(idx - 2);
                    int n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class}, (Object)object2, n2)) {
                        case -1: {
                            generator.push(null);
                            continue block23;
                        }
                        case 0: {
                            String string = (String)object2;
                            generator.push(string);
                            continue block23;
                        }
                        case 1: {
                            Character ch = (Character)object2;
                            generator.push(ch.charValue());
                            continue block23;
                        }
                        case 2: {
                            Byte b = (Byte)object2;
                            generator.push(b.byteValue());
                            continue block23;
                        }
                        case 3: {
                            Short s = (Short)object2;
                            generator.push(s.shortValue());
                            continue block23;
                        }
                        case 4: {
                            Integer i = (Integer)object2;
                            generator.push(i);
                            continue block23;
                        }
                        case 5: {
                            Long l = (Long)object2;
                            generator.push(l);
                            continue block23;
                        }
                        case 6: {
                            Float f = (Float)object2;
                            generator.push(f.floatValue());
                            continue block23;
                        }
                        case 7: {
                            Double d = (Double)object2;
                            generator.push(d);
                            continue block23;
                        }
                        case 8: {
                            Boolean bool = (Boolean)object2;
                            generator.push(bool);
                            continue block23;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported constant type '%s' in parameters for field '%s' in enum '%s' specified by mod '%s'", paramList.get(idx - 2).getClass(), proto.fieldName(), proto.enumName(), proto.owningMod()));
                        }
                    }
                }
            }
        }
    }

    private static void buildExtensionInfo(ClassNode classNode, Type classType, ListGeneratorAdapter generator, FieldNode infoField, int vanillaCount, int moddedCount) {
        String netCheckValue = null;
        if (classNode.visibleAnnotations != null) {
            netCheckValue = classNode.visibleAnnotations.stream().filter(anno -> anno.desc.equals(NETWORKED_ANNOTATION.getDescriptor())).findFirst().flatMap(anno -> {
                if (anno.values == null) {
                    throw new IllegalStateException("Expected values on NetworkedEnum annotation");
                }
                for (int i = 0; i < anno.values.size(); i += 2) {
                    if (!anno.values.get(i).equals("value")) continue;
                    String[] value = (String[])anno.values.get(i + 1);
                    return Optional.of(value[1]);
                }
                throw new IllegalStateException("Expected NetworkedEnum.NetworkCheck value on NetworkedEnum annotation");
            }).orElse(null);
        }
        generator.newInstance(EXT_INFO);
        generator.dup();
        generator.push(moddedCount > 0);
        generator.push(vanillaCount);
        generator.push(vanillaCount + moddedCount);
        if (netCheckValue != null) {
            generator.getStatic(NET_CHECK, netCheckValue, NET_CHECK);
        } else {
            generator.push(null);
        }
        generator.invokeConstructor(EXT_INFO, new Method("<init>", EXT_INFO_CTOR_DESC));
        generator.putStatic(classType, infoField.name, EXT_INFO);
    }

    private static void returnValuesToExtender(Type classType, ListGeneratorAdapter generator, List<EnumPrototype> protos, List<FieldNode> entries) {
        for (int i = 0; i < protos.size(); ++i) {
            Type owner;
            Object object;
            EnumPrototype prototype = protos.get(i);
            EnumParameters enumParameters = prototype.ctorParams();
            if (!(enumParameters instanceof EnumParameters.FieldReference)) continue;
            EnumParameters.FieldReference fieldReference = (EnumParameters.FieldReference)enumParameters;
            try {
                owner = object = fieldReference.owner();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object fieldName = object = fieldReference.fieldName();
            FieldNode field = entries.get(i);
            generator.getStatic(owner, (String)fieldName, ENUM_PROXY);
            generator.getStatic(classType, field.name, classType);
            generator.invokeVirtual(ENUM_PROXY, new Method("setValue", "(Ljava/lang/Enum;)V"));
        }
    }

    private static void appendValuesArray(Type classType, ListGeneratorAdapter generator, List<FieldNode> enumEntries) {
        generator.dup();
        generator.arrayLength();
        generator.push(enumEntries.size());
        generator.math(96, Type.INT_TYPE);
        generator.invokeStatic(ARRAYS, new Method("copyOf", "([Ljava/lang/Object;I)[Ljava/lang/Object;"));
        generator.checkCast(Type.getType((String)("[" + classType.getDescriptor())));
        for (FieldNode entry : enumEntries) {
            generator.dup();
            generator.getStatic(classType, entry.name, classType);
            generator.dup();
            generator.invokeVirtual(classType, new Method("ordinal", "()I"));
            generator.swap();
            generator.arrayStore(classType);
        }
    }

    public static void loadEnumPrototypes(Map<IModInfo, JarResource> paths) {
        prototypes = paths.entrySet().stream().map(entry -> EnumPrototype.load((IModInfo)entry.getKey(), (JarResource)entry.getValue())).flatMap(Collection::stream).sorted().reduce(new HashMap(), (map, proto) -> {
            map.computeIfAbsent(proto.enumName(), ignored -> new ArrayList()).add(proto);
            return map;
        }, (protoOne, protoTwo) -> {
            throw new IllegalStateException("Duplicate EnumPrototype: " + String.valueOf(protoOne));
        });
        HashSet<String> erroredEnums = new HashSet<String>();
        for (Map.Entry<String, List<EnumPrototype>> entry2 : prototypes.entrySet()) {
            HashMap<String, EnumPrototype> distinctPrototypes = new HashMap<String, EnumPrototype>();
            boolean foundDupe = false;
            for (EnumPrototype proto2 : entry2.getValue()) {
                EnumPrototype prevProto = distinctPrototypes.put(proto2.fieldName(), proto2);
                if (prevProto == null) continue;
                foundDupe = true;
                ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.enumextender.duplicate", proto2.fieldName(), proto2.enumName(), proto2.owningMod(), prevProto.owningMod()));
            }
            if (!foundDupe) continue;
            erroredEnums.add(entry2.getKey());
        }
        erroredEnums.forEach(prototypes::remove);
    }

    public static String validateNameParameter(String fieldName, String owningMod) {
        if (!fieldName.startsWith(owningMod + ":")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Name parameter must be prefixed by mod ID: '%s' provided by mod '%s'", fieldName, owningMod));
        }
        return fieldName;
    }
}

