/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClassLoadingGuardian
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoadingGuardian.class);
    private final Instrumentation instrumentation;
    private final Set<String> protectedPackages;
    private final ClassFileTransformer guardianTransformer;
    private volatile boolean uninstalled;
    private volatile ClassLoader allowedClassLoader;

    public ClassLoadingGuardian(Instrumentation instrumentation, List<ModFile> gameContent) {
        this.instrumentation = instrumentation;
        this.protectedPackages = ClassLoadingGuardian.getPackages(gameContent);
        this.guardianTransformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                if (ClassLoadingGuardian.this.uninstalled) {
                    return null;
                }
                if (loader == ClassLoadingGuardian.this.allowedClassLoader) {
                    return null;
                }
                String packageName = ClassLoadingGuardian.getPackageName(className);
                if (packageName != null && ClassLoadingGuardian.this.protectedPackages.contains(packageName)) {
                    LOGGER.error("Illegal load of protected class {} into class-loader {}", new Object[]{className, loader, new Throwable()});
                    ClassWriter cw = new ClassWriter(3);
                    cw.visit(52, 1, className.replace('.', '/'), null, Type.getInternalName(Object.class), null);
                    MethodVisitor mv = cw.visitMethod(9, "<clinit>", "()V", null, null);
                    mv.visitCode();
                    mv.visitMethodInsn(184, Type.getInternalName(ClassLoadingGuardian.class), "fail", "()V", false);
                    mv.visitInsn(177);
                    mv.visitMaxs(0, 0);
                    mv.visitEnd();
                    cw.visitEnd();
                    return cw.toByteArray();
                }
                return null;
            }
        };
        this.instrumentation.addTransformer(this.guardianTransformer);
    }

    public static void fail() {
        throw new IllegalStateException();
    }

    public void setAllowedClassLoader(ClassLoader allowedClassLoader) {
        this.allowedClassLoader = allowedClassLoader;
        ArrayList<Class> foundIssues = new ArrayList<Class>();
        for (Class loadedClass : this.instrumentation.getAllLoadedClasses()) {
            String physicalPackage;
            if (loadedClass.getClassLoader() == null || !this.protectedPackages.contains(physicalPackage = loadedClass.getPackageName().replace('.', '/')) || !this.isReachableFrom(loadedClass.getClassLoader(), allowedClassLoader)) continue;
            foundIssues.add(loadedClass);
        }
        if (!foundIssues.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Classes were loaded on the wrong class-loader:\n");
            for (Class offendingClass : foundIssues) {
                message.append(' ').append(offendingClass.getName()).append(" from ").append(offendingClass.getClassLoader()).append('\n');
            }
            throw new IllegalArgumentException(message.toString());
        }
    }

    @Override
    public void close() {
        if (!this.uninstalled) {
            this.uninstalled = true;
            this.instrumentation.removeTransformer(this.guardianTransformer);
            this.allowedClassLoader = null;
        }
    }

    private static Set<String> getPackages(List<ModFile> gameContent) {
        HashSet<String> protectedPackages = new HashSet<String>(1000);
        for (ModFile modFile : gameContent) {
            for (String pkgName : modFile.getSecureJar().moduleDataProvider().descriptor().packages()) {
                protectedPackages.add(pkgName.replace('.', '/'));
            }
        }
        return protectedPackages;
    }

    private boolean isReachableFrom(ClassLoader classLoader, ClassLoader origin) {
        if (classLoader == origin) {
            return true;
        }
        if (origin.getParent() != null) {
            return this.isReachableFrom(classLoader, origin.getParent());
        }
        return false;
    }

    @Nullable
    private static String getPackageName(String className) {
        int lastPkgSepIdx = className.lastIndexOf(47);
        if (lastPkgSepIdx != -1) {
            return className.substring(0, lastPkgSepIdx);
        }
        return null;
    }
}

