/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.mixin;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import net.neoforged.fml.classloading.transformation.ClassTransformStatistics;
import net.neoforged.fml.loading.mixin.FMLMixinClassProcessor;
import net.neoforged.neoforgespi.transformation.BytecodeProvider;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.transformers.MixinClassReader;

class FMLClassBytecodeProvider
implements IClassBytecodeProvider {
    private final BytecodeProvider bytecodeProvider;
    private final FMLMixinClassProcessor classProcessor;

    FMLClassBytecodeProvider(BytecodeProvider bytecodeProvider, FMLMixinClassProcessor classProcessor) {
        this.bytecodeProvider = bytecodeProvider;
        this.classProcessor = classProcessor;
    }

    public ClassNode getClassNode(String name) throws ClassNotFoundException {
        return this.getClassNode(name, true, 0);
    }

    public ClassNode getClassNode(String name, boolean runTransformers) throws ClassNotFoundException {
        return this.getClassNode(name, runTransformers, 8);
    }

    public ClassNode getClassNode(String name, boolean runTransformers, int readerFlags) throws ClassNotFoundException {
        ClassNode classNode;
        byte[] classBytes;
        if (!runTransformers) {
            throw new IllegalArgumentException("FML service does not currently support retrieval of untransformed bytecode");
        }
        String canonicalName = name.replace('/', '.');
        String internalName = name.replace('.', '/');
        try {
            classBytes = this.bytecodeProvider.getByteCode(canonicalName);
        }
        catch (ClassNotFoundException ex) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(internalName + ".class");
            if (url == null) {
                throw ex;
            }
            try {
                classBytes = Resources.asByteSource((URL)url).read();
            }
            catch (IOException ioex) {
                throw ex;
            }
        }
        if (classBytes != null && classBytes.length != 0) {
            ClassNode classNode2 = new ClassNode();
            MixinClassReader classReader = new MixinClassReader(classBytes, canonicalName);
            classReader.accept((ClassVisitor)classNode2, readerFlags);
            ClassTransformStatistics.incrementMixinParsedClasses();
            return classNode2;
        }
        Type classType = Type.getObjectType((String)internalName);
        if (this.classProcessor.generatesClass(classType) && this.classProcessor.generateClass(classType, classNode = new ClassNode())) {
            return classNode;
        }
        throw new ClassNotFoundException(canonicalName);
    }
}

