/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.modscan;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.modscan.ModClassVisitor;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;

public class Scanner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ModFile fileToScan;

    public Scanner(ModFile fileToScan) {
        this.fileToScan = fileToScan;
    }

    public ModFileScanData scan() {
        ModFileScanData result = new ModFileScanData();
        result.addModFileInfo(this.fileToScan.getModFileInfo());
        this.fileToScan.getSecureJar().contents().visitContent((relativePath, resource) -> {
            if (relativePath.endsWith(".class")) {
                try (InputStream in = resource.open();){
                    ModClassVisitor mcv = new ModClassVisitor();
                    ClassReader cr = new ClassReader(in);
                    cr.accept((ClassVisitor)mcv, 3);
                    mcv.buildData(result.getClasses(), result.getAnnotations());
                }
                catch (IOException | IllegalArgumentException e) {
                    LOGGER.error(LogMarkers.SCAN, "Exception scanning {} path {}", new Object[]{this.fileToScan, relativePath, e});
                }
            }
        });
        return result;
    }
}

