/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.startup;

import java.lang.invoke.MethodHandle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.ProgramArgs;
import net.neoforged.fml.startup.Entrypoint;
import net.neoforged.fml.startup.FatalErrorReporting;

public class Client
extends Entrypoint {
    private Client() {
    }

    public static void main(String[] args) {
        try (FMLLoader loader = Client.startup(args, false, Dist.CLIENT, true);){
            if (!loader.isProduction()) {
                Client.preProcessDevArguments(loader.getProgramArgs());
            }
            MethodHandle main = Client.createMainMethodCallable(loader, "net.minecraft.client.main.Main");
            main.invokeExact(loader.getProgramArgs().getArguments());
        }
        catch (Throwable t) {
            FatalErrorReporting.reportFatalError(t);
            System.exit(1);
        }
    }

    private static void preProcessDevArguments(ProgramArgs args) {
        String username = args.get("username");
        if (username != null) {
            Matcher m = Pattern.compile("#+").matcher(username);
            StringBuilder replaced = new StringBuilder();
            while (m.find()) {
                m.appendReplacement(replaced, Client.getRandomNumbers(m.group().length()));
            }
            m.appendTail(replaced);
            args.put("username", replaced.toString());
        } else {
            args.putLazy("username", "Dev");
        }
        if (!args.hasValue("accessToken")) {
            args.put("accessToken", "0");
        }
    }

    private static String getRandomNumbers(int length) {
        return Long.toString(System.nanoTime() % (long)((int)Math.pow(10.0, length)));
    }
}

